/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.gzd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mil.nga.mgrs.MGRS;
import mil.nga.mgrs.MGRSUtils;
import mil.nga.mgrs.features.Bounds;
import mil.nga.mgrs.features.Point;
import mil.nga.mgrs.gzd.BandLetterRange;
import mil.nga.mgrs.gzd.GridRange;
import mil.nga.mgrs.gzd.GridZone;
import mil.nga.mgrs.gzd.LatitudeBand;
import mil.nga.mgrs.gzd.LongitudinalStrip;
import mil.nga.mgrs.gzd.ZoneNumberRange;

public class GridZones {
    public static final Map<Integer, LongitudinalStrip> strips = new HashMap<Integer, LongitudinalStrip>();
    public static final Map<Character, LatitudeBand> bands = new HashMap<Character, LatitudeBand>();
    public static final Map<Integer, Map<Character, GridZone>> gridZones = new HashMap<Integer, Map<Character, GridZone>>();

    public static LongitudinalStrip getLongitudinalStrip(int zoneNumber) {
        MGRSUtils.validateZoneNumber(zoneNumber);
        return strips.get(zoneNumber);
    }

    public static double getWestLongitude(int zoneNumber) {
        return GridZones.getLongitudinalStrip(zoneNumber).getWest();
    }

    public static double getEastLongitude(int zoneNumber) {
        return GridZones.getLongitudinalStrip(zoneNumber).getEast();
    }

    public static LatitudeBand getLatitudeBand(char bandLetter) {
        MGRSUtils.validateBandLetter(bandLetter);
        return bands.get(Character.valueOf(bandLetter));
    }

    public static double getSouthLatitude(char bandLetter) {
        return GridZones.getLatitudeBand(bandLetter).getSouth();
    }

    public static double getNorthLatitude(char bandLetter) {
        return GridZones.getLatitudeBand(bandLetter).getNorth();
    }

    public static List<GridZone> getZones(Bounds bounds) {
        ArrayList<GridZone> zones = new ArrayList<GridZone>();
        GridRange gridRange = GridZones.getGridRange(bounds);
        for (GridZone zone : gridRange) {
            zones.add(zone);
        }
        return zones;
    }

    public static GridZone getGridZone(int zoneNumber, char bandLetter) {
        MGRSUtils.validateZoneNumber(zoneNumber);
        MGRSUtils.validateBandLetter(bandLetter);
        return gridZones.get(zoneNumber).get(Character.valueOf(bandLetter));
    }

    public static GridZone getGridZone(MGRS mgrs) {
        return GridZones.getGridZone(mgrs.getZone(), mgrs.getBand());
    }

    public static GridRange getGridRange(Bounds bounds) {
        bounds = bounds.toDegrees();
        ZoneNumberRange zoneNumberRange = GridZones.getZoneNumberRange(bounds);
        BandLetterRange bandLetterRange = GridZones.getBandLetterRange(bounds);
        return new GridRange(zoneNumberRange, bandLetterRange);
    }

    public static ZoneNumberRange getZoneNumberRange(Bounds bounds) {
        bounds = bounds.toDegrees();
        return GridZones.getZoneNumberRange(bounds.getWest(), bounds.getEast());
    }

    public static ZoneNumberRange getZoneNumberRange(double west, double east) {
        int westZone = GridZones.getZoneNumber(west, false);
        int eastZone = GridZones.getZoneNumber(east, true);
        return new ZoneNumberRange(westZone, eastZone);
    }

    public static int getZoneNumber(Point point) {
        point = point.toDegrees();
        return GridZones.getZoneNumber(point.getLongitude(), point.getLatitude());
    }

    public static int getZoneNumber(double longitude, double latitude) {
        int zoneNumber = GridZones.getZoneNumber(longitude);
        boolean svalbardZone = GridZones.isSvalbardZone(zoneNumber);
        boolean norwayZone = GridZones.isNorwayZone(zoneNumber);
        if (svalbardZone || norwayZone) {
            char bandLetter = GridZones.getBandLetter(latitude);
            if (svalbardZone && GridZones.isSvalbardLetter(bandLetter)) {
                zoneNumber = GridZones.getSvalbardZone(longitude);
            } else if (norwayZone && GridZones.isNorwayLetter(bandLetter)) {
                zoneNumber = GridZones.getNorwayZone(longitude);
            }
        }
        return zoneNumber;
    }

    public static int getZoneNumber(double longitude) {
        return GridZones.getZoneNumber(longitude, true);
    }

    public static int getZoneNumber(double longitude, boolean eastern) {
        if (longitude < -180.0 || longitude > 180.0) {
            longitude = (longitude - -180.0) % 360.0 + -180.0;
        }
        double zoneValue = (longitude - -180.0) / 6.0;
        int zoneNumber = 1 + (int)zoneValue;
        if (!eastern) {
            if (zoneNumber > 1 && zoneValue % 1.0 == 0.0) {
                --zoneNumber;
            }
        } else if (zoneNumber > 60) {
            --zoneNumber;
        }
        return zoneNumber;
    }

    public static BandLetterRange getBandLetterRange(Bounds bounds) {
        bounds = bounds.toDegrees();
        return GridZones.getBandLetterRange(bounds.getSouth(), bounds.getNorth());
    }

    public static BandLetterRange getBandLetterRange(double south, double north) {
        char southLetter = GridZones.getBandLetter(south, false);
        char northLetter = GridZones.getBandLetter(north, true);
        return new BandLetterRange(southLetter, northLetter);
    }

    public static char getBandLetter(double latitude) {
        return GridZones.getBandLetter(latitude, true);
    }

    public static char getBandLetter(double latitude, boolean northern) {
        if (latitude < -80.0) {
            latitude = -80.0;
        } else if (latitude > 84.0) {
            latitude = 84.0;
        }
        double bandValue = (latitude - -80.0) / 8.0;
        int bands = (int)bandValue;
        if (bands >= 20) {
            --bands;
        } else if (!northern && bands > 0 && bandValue % 1.0 == 0.0) {
            --bands;
        }
        if (bands > 10) {
            bands += 2;
        } else if (bands > 5) {
            ++bands;
        }
        char letter = 'C';
        letter = (char)(letter + bands);
        return letter;
    }

    public static boolean isSvalbard(int zoneNumber, char bandLetter) {
        return GridZones.isSvalbardLetter(bandLetter) && GridZones.isSvalbardZone(zoneNumber);
    }

    public static boolean isSvalbardLetter(char bandLetter) {
        return bandLetter == 'X';
    }

    public static boolean isSvalbardZone(int zoneNumber) {
        return zoneNumber >= 31 && zoneNumber <= 37;
    }

    private static LongitudinalStrip getSvalbardStrip(LongitudinalStrip strip) {
        LongitudinalStrip svalbardStrip = null;
        int number = strip.getNumber();
        if (number % 2 == 1) {
            double west = strip.getWest();
            double east = strip.getEast();
            double halfWidth = (east - west) / 2.0;
            if (number > 31) {
                west -= halfWidth;
            }
            if (number < 37) {
                east += halfWidth;
            }
            svalbardStrip = new LongitudinalStrip(number, west, east);
        }
        return svalbardStrip;
    }

    private static int getSvalbardZone(double longitude) {
        double minimumLongitude = GridZones.getWestLongitude(31);
        double zoneValue = 31.0 + (longitude - minimumLongitude) / 6.0;
        int zone = (int)Math.round(zoneValue);
        if (zone % 2 == 0) {
            --zone;
        }
        return zone;
    }

    private static boolean isNorway(int zoneNumber, char bandLetter) {
        return GridZones.isNorwayLetter(bandLetter) && GridZones.isNorwayZone(zoneNumber);
    }

    private static boolean isNorwayLetter(char bandLetter) {
        return bandLetter == 'V';
    }

    private static boolean isNorwayZone(int zoneNumber) {
        return zoneNumber >= 31 && zoneNumber <= 32;
    }

    private static LongitudinalStrip getNorwayStrip(LongitudinalStrip strip) {
        int number = strip.getNumber();
        double west = strip.getWest();
        double east = strip.getEast();
        double halfWidth = (east - west) / 2.0;
        int expand = 0;
        if (number == 31) {
            east -= halfWidth;
            ++expand;
        } else if (number == 32) {
            west -= halfWidth;
        }
        return new LongitudinalStrip(number, west, east, expand);
    }

    private static int getNorwayZone(double longitude) {
        double minimumLongitude = GridZones.getWestLongitude(31);
        int zone = 31;
        if (longitude >= minimumLongitude + 3.0) {
            ++zone;
        }
        return zone;
    }

    static {
        ZoneNumberRange numberRange = new ZoneNumberRange();
        for (int zoneNumber : numberRange) {
            double longitude = -180.0 + (double)(zoneNumber - 1) * 6.0;
            LongitudinalStrip strip = new LongitudinalStrip(zoneNumber, longitude, longitude + 6.0);
            strips.put(strip.getNumber(), strip);
        }
        double latitude = -80.0;
        BandLetterRange letterRange = new BandLetterRange();
        Iterator<Object> iterator = letterRange.iterator();
        while (iterator.hasNext()) {
            char bandLetter = iterator.next().charValue();
            double min = latitude;
            latitude = bandLetter == 'X' ? (latitude += 12.0) : (latitude += 8.0);
            bands.put(Character.valueOf(bandLetter), new LatitudeBand(bandLetter, min, latitude));
        }
        for (LongitudinalStrip strip : strips.values()) {
            int zoneNumber = strip.getNumber();
            HashMap<Character, GridZone> stripGridZones = new HashMap<Character, GridZone>();
            for (LatitudeBand band : bands.values()) {
                char bandLetter = band.getLetter();
                LongitudinalStrip gridZoneStrip = strip;
                if (GridZones.isSvalbard(zoneNumber, bandLetter)) {
                    gridZoneStrip = GridZones.getSvalbardStrip(strip);
                } else if (GridZones.isNorway(zoneNumber, bandLetter)) {
                    gridZoneStrip = GridZones.getNorwayStrip(strip);
                }
                if (gridZoneStrip == null) continue;
                stripGridZones.put(Character.valueOf(bandLetter), new GridZone(gridZoneStrip, band));
            }
            gridZones.put(zoneNumber, stripGridZones);
        }
    }
}

