/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.property;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MGRSProperties {
    private static final Logger log = Logger.getLogger(MGRSProperties.class.getName());
    private static Properties mProperties;

    public static String getProperty(String key) {
        return MGRSProperties.getProperty(key, true);
    }

    public static synchronized String getProperty(String key, boolean required) {
        String value;
        if (mProperties == null) {
            mProperties = MGRSProperties.initializeConfigurationProperties();
        }
        if ((value = mProperties.getProperty(key)) != null && value.trim().isEmpty()) {
            value = null;
        }
        if (value == null && required) {
            throw new IllegalArgumentException("Property not found: " + key);
        }
        return value;
    }

    public static String getProperty(String ... properties) {
        return MGRSProperties.getProperty(true, properties);
    }

    public static String getProperty(boolean required, String ... properties) {
        return MGRSProperties.getProperty(MGRSProperties.buildProperty(properties), required);
    }

    public static int getIntegerProperty(String key) {
        return MGRSProperties.getIntegerProperty(key, true);
    }

    public static Integer getIntegerProperty(String key, boolean required) {
        Integer value = null;
        String stringValue = MGRSProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Integer.valueOf(stringValue);
        }
        return value;
    }

    public static int getIntegerProperty(String ... properties) {
        return MGRSProperties.getIntegerProperty(true, properties);
    }

    public static Integer getIntegerProperty(boolean required, String ... properties) {
        return MGRSProperties.getIntegerProperty(MGRSProperties.buildProperty(properties), required);
    }

    public static float getFloatProperty(String key) {
        return MGRSProperties.getFloatProperty(key, true).floatValue();
    }

    public static Float getFloatProperty(String key, boolean required) {
        Float value = null;
        String stringValue = MGRSProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Float.valueOf(stringValue);
        }
        return value;
    }

    public static float getFloatProperty(String ... properties) {
        return MGRSProperties.getFloatProperty(true, properties).floatValue();
    }

    public static Float getFloatProperty(boolean required, String ... properties) {
        return MGRSProperties.getFloatProperty(MGRSProperties.buildProperty(properties), required);
    }

    public static double getDoubleProperty(String key) {
        return MGRSProperties.getDoubleProperty(key, true);
    }

    public static Double getDoubleProperty(String key, boolean required) {
        Double value = null;
        String stringValue = MGRSProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Double.valueOf(stringValue);
        }
        return value;
    }

    public static double getDoubleProperty(String ... properties) {
        return MGRSProperties.getDoubleProperty(true, properties);
    }

    public static Double getDoubleProperty(boolean required, String ... properties) {
        return MGRSProperties.getDoubleProperty(MGRSProperties.buildProperty(properties), required);
    }

    public static boolean getBooleanProperty(String key) {
        return MGRSProperties.getBooleanProperty(key, true);
    }

    public static Boolean getBooleanProperty(String key, boolean required) {
        Boolean value = null;
        String stringValue = MGRSProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Boolean.valueOf(stringValue);
        }
        return value;
    }

    public static boolean getBooleanProperty(String ... properties) {
        return MGRSProperties.getBooleanProperty(true, properties);
    }

    public static Boolean getBooleanProperty(boolean required, String ... properties) {
        return MGRSProperties.getBooleanProperty(MGRSProperties.buildProperty(properties), required);
    }

    private static Properties initializeConfigurationProperties() {
        Properties properties = new Properties();
        InputStream in = MGRSProperties.class.getResourceAsStream("/mgrs.properties");
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to load properties file: mgrs.properties", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Failed to close properties file: mgrs.properties", e);
                }
            }
        } else {
            log.log(Level.SEVERE, "Failed to load properties, file not found: mgrs.properties");
        }
        return properties;
    }

    public static String buildProperty(String ... properties) {
        StringBuilder combined = new StringBuilder();
        for (String property : properties) {
            if (property == null) continue;
            if (combined.length() > 0) {
                combined.append(".");
            }
            combined.append(property);
        }
        return combined.toString();
    }
}

