/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.features;

import mil.nga.mgrs.features.Point;
import mil.nga.mgrs.features.Unit;
import mil.nga.mgrs.grid.GridType;

public class Line {
    private Point point1;
    private Point point2;
    private GridType gridType;

    public static Line line(Point point1, Point point2) {
        return new Line(point1, point2);
    }

    public static Line line(Point point1, Point point2, GridType gridType) {
        return new Line(point1, point2, gridType);
    }

    public Line(Point point1, Point point2) {
        this.setPoints(point1, point2);
    }

    public Line(Point point1, Point point2, GridType gridType) {
        this(point1, point2);
        this.gridType = gridType;
    }

    public Point getPoint1() {
        return this.point1;
    }

    public void setPoint1(Point point1) {
        this.point1 = point1;
        this.validateUnits();
    }

    public Point getPoint2() {
        return this.point2;
    }

    public void setPoint2(Point point2) {
        this.point2 = point2;
        this.validateUnits();
    }

    public void setPoints(Point point1, Point point2) {
        this.point1 = point1;
        this.point2 = point2;
        this.validateUnits();
    }

    public Unit getUnit() {
        return this.point1.getUnit();
    }

    public boolean isUnit(Unit unit) {
        return this.point1.isUnit(unit);
    }

    public boolean isDegrees() {
        return this.point1.isDegrees();
    }

    public boolean isMeters() {
        return this.point1.isMeters();
    }

    public Line toUnit(Unit unit) {
        Line line = null;
        line = this.isUnit(unit) ? this : new Line(this.point1.toUnit(unit), this.point2.toUnit(unit), this.gridType);
        return line;
    }

    public Line toDegrees() {
        return this.toUnit(Unit.DEGREE);
    }

    public Line toMeters() {
        return this.toUnit(Unit.METER);
    }

    public GridType getGridType() {
        return this.gridType;
    }

    public boolean hasGridType() {
        return this.gridType != null;
    }

    public void setGridType(GridType gridType) {
        this.gridType = gridType;
    }

    private void validateUnits() {
        if (!this.point1.isUnit(this.point2.getUnit())) {
            throw new IllegalArgumentException("Points are in different units. point1: " + this.point1.getUnit() + ", point2: " + this.point2.getUnit());
        }
    }
}

