/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.features;

import java.text.ParseException;
import mil.nga.mgrs.MGRS;
import mil.nga.mgrs.MGRSUtils;
import mil.nga.mgrs.features.Bounds;
import mil.nga.mgrs.features.Unit;
import mil.nga.mgrs.gzd.GridZones;
import mil.nga.mgrs.tile.MGRSTile;
import mil.nga.mgrs.tile.Pixel;
import mil.nga.mgrs.utm.Hemisphere;
import mil.nga.mgrs.utm.UTM;

public class Point {
    private double latitude;
    private double longitude;
    private Unit unit;

    public static Point create(double longitude, double latitude) {
        return Point.degrees(longitude, latitude);
    }

    public static Point create(double longitude, double latitude, Unit unit) {
        return new Point(longitude, latitude, unit);
    }

    public static Point degrees(double longitude, double latitude) {
        return Point.create(longitude, latitude, Unit.DEGREE);
    }

    public static Point meters(double longitude, double latitude) {
        return Point.create(longitude, latitude, Unit.METER);
    }

    public static Point toUnit(Unit fromUnit, double longitude, double latitude, Unit toUnit) {
        return MGRSUtils.toUnit(fromUnit, longitude, latitude, toUnit);
    }

    public static Point toUnit(double longitude, double latitude, Unit unit) {
        return MGRSUtils.toUnit(longitude, latitude, unit);
    }

    public static Point degreesToMeters(double longitude, double latitude) {
        return Point.toUnit(Unit.DEGREE, longitude, latitude, Unit.METER);
    }

    public static Point metersToDegrees(double longitude, double latitude) {
        return Point.toUnit(Unit.METER, longitude, latitude, Unit.DEGREE);
    }

    public static Point create(int zoneNumber, Hemisphere hemisphere, double easting, double northing) {
        return UTM.create(zoneNumber, hemisphere, easting, northing).toPoint();
    }

    public Point(double longitude, double latitude) {
        this(longitude, latitude, Unit.DEGREE);
    }

    public Point(double longitude, double latitude, Unit unit) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.unit = unit;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public boolean isUnit(Unit unit) {
        return this.unit == unit;
    }

    public boolean isDegrees() {
        return this.isUnit(Unit.DEGREE);
    }

    public boolean isMeters() {
        return this.isUnit(Unit.METER);
    }

    public Point toUnit(Unit unit) {
        Point point = null;
        point = this.isUnit(unit) ? this : MGRSUtils.toUnit(this.unit, this.longitude, this.latitude, unit);
        return point;
    }

    public Point toDegrees() {
        return this.toUnit(Unit.DEGREE);
    }

    public Point toMeters() {
        return this.toUnit(Unit.METER);
    }

    public MGRS toMGRS() {
        return MGRS.from(this);
    }

    public UTM toUTM() {
        return UTM.from(this);
    }

    public Pixel getPixel(MGRSTile tile) {
        return this.getPixel(tile.getWidth(), tile.getHeight(), tile.getBounds());
    }

    public Pixel getPixel(int width, int height, Bounds bounds) {
        return MGRSUtils.getPixel(width, height, bounds, this);
    }

    public int getZoneNumber() {
        return GridZones.getZoneNumber(this);
    }

    public char getBandLetter() {
        return GridZones.getBandLetter(this.toDegrees().getLatitude());
    }

    public Hemisphere getHemisphere() {
        return Hemisphere.fromLatitude(this.latitude);
    }

    public static Point from(UTM utm) {
        double north = utm.getNorthing();
        if (utm.getHemisphere() == Hemisphere.SOUTH) {
            north -= 1.0E7;
        }
        int zone = utm.getZone();
        double easting = utm.getEasting();
        double latitude = (north / 6366197.724 / 0.9996 + (1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) - 0.006739496742 * Math.sin(north / 6366197.724 / 0.9996) * Math.cos(north / 6366197.724 / 0.9996) * (Math.atan(Math.cos(Math.atan((Math.exp((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) / 3.0)) - Math.exp(-(easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) / 3.0))) / 2.0 / Math.cos((north - 6397033.7875500005 * (north / 6366197.724 / 0.9996 - 0.0050546225565 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.pow(0.0050546225565, 2.0) * 5.0 / 3.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 - Math.pow(0.0050546225565, 3.0) * 35.0 / 27.0 * (5.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 3.0)) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) + north / 6366197.724 / 0.9996))) * Math.tan((north - 6397033.7875500005 * (north / 6366197.724 / 0.9996 - 0.0050546225565 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.pow(0.0050546225565, 2.0) * 5.0 / 3.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 - Math.pow(0.0050546225565, 3.0) * 35.0 / 27.0 * (5.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 3.0)) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) + north / 6366197.724 / 0.9996)) - north / 6366197.724 / 0.9996) * 3.0 / 2.0) * (Math.atan(Math.cos(Math.atan((Math.exp((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) / 3.0)) - Math.exp(-(easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) / 3.0))) / 2.0 / Math.cos((north - 6397033.7875500005 * (north / 6366197.724 / 0.9996 - 0.0050546225565 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.pow(0.0050546225565, 2.0) * 5.0 / 3.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 - Math.pow(0.0050546225565, 3.0) * 35.0 / 27.0 * (5.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 3.0)) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) + north / 6366197.724 / 0.9996))) * Math.tan((north - 6397033.7875500005 * (north / 6366197.724 / 0.9996 - 0.0050546225565 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.pow(0.0050546225565, 2.0) * 5.0 / 3.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 - Math.pow(0.0050546225565, 3.0) * 35.0 / 27.0 * (5.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 3.0)) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) + north / 6366197.724 / 0.9996)) - north / 6366197.724 / 0.9996)) * 180.0 / Math.PI;
        latitude = Math.round(latitude * 1.0E7);
        double longitude = Math.atan((Math.exp((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) / 3.0)) - Math.exp(-(easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) / 3.0))) / 2.0 / Math.cos((north - 6397033.7875500005 * (north / 6366197.724 / 0.9996 - 0.0050546225565 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.pow(0.0050546225565, 2.0) * 5.0 / 3.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 - Math.pow(0.0050546225565, 3.0) * 35.0 / 27.0 * (5.0 * (3.0 * (north / 6366197.724 / 0.9996 + Math.sin(2.0 * north / 6366197.724 / 0.9996) / 2.0) + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 4.0 + Math.sin(2.0 * north / 6366197.724 / 0.9996) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0) * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) / 3.0)) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))) * (1.0 - 0.006739496742 * Math.pow((easting - 500000.0) / (6397033.7875500005 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0))), 2.0) / 2.0 * Math.pow(Math.cos(north / 6366197.724 / 0.9996), 2.0)) + north / 6366197.724 / 0.9996)) * 180.0 / Math.PI + (double)(zone * 6) - 183.0;
        longitude = Math.round(longitude * 1.0E7);
        return Point.degrees(longitude /= 1.0E7, latitude /= 1.0E7);
    }

    public static Point from(MGRS mgrs) {
        return mgrs.toUTM().toPoint();
    }

    public static Point parse(String mgrs) throws ParseException {
        return MGRS.parse(mgrs).toPoint();
    }
}

