/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.grid;

import java.util.ArrayList;
import java.util.List;
import mil.nga.mgrs.MGRS;
import mil.nga.mgrs.color.Color;
import mil.nga.mgrs.features.Bounds;
import mil.nga.mgrs.features.Point;
import mil.nga.mgrs.grid.GridType;
import mil.nga.mgrs.grid.Label;
import mil.nga.mgrs.grid.Labeler;
import mil.nga.mgrs.gzd.GridZone;
import mil.nga.mgrs.utm.Hemisphere;

public class GridLabeler
extends Labeler {
    public GridLabeler() {
    }

    public GridLabeler(int minZoom, Color color) {
        super(minZoom, color);
    }

    public GridLabeler(int minZoom, Color color, double textSize) {
        super(minZoom, color, textSize);
    }

    public GridLabeler(int minZoom, Color color, double textSize, double buffer) {
        super(minZoom, color, textSize, buffer);
    }

    public GridLabeler(int minZoom, Integer maxZoom, Color color) {
        super(minZoom, maxZoom, color);
    }

    public GridLabeler(int minZoom, Integer maxZoom, Color color, double textSize) {
        super(minZoom, maxZoom, color, textSize);
    }

    public GridLabeler(int minZoom, Integer maxZoom, Color color, double textSize, double buffer) {
        super(minZoom, maxZoom, color, textSize, buffer);
    }

    public GridLabeler(boolean enabled, int minZoom, Integer maxZoom, Color color) {
        super(enabled, minZoom, maxZoom, color);
    }

    public GridLabeler(boolean enabled, int minZoom, Integer maxZoom, Color color, double textSize) {
        super(enabled, minZoom, maxZoom, color, textSize);
    }

    public GridLabeler(boolean enabled, int minZoom, Integer maxZoom, Color color, double textSize, double buffer) {
        super(enabled, minZoom, maxZoom, color, textSize, buffer);
    }

    @Override
    public List<Label> getLabels(Bounds tileBounds, GridType gridType, GridZone zone) {
        ArrayList<Label> labels = null;
        Bounds drawBounds = zone.getDrawBounds(tileBounds, gridType);
        if (drawBounds != null) {
            labels = new ArrayList<Label>();
            int precision = gridType.getPrecision();
            for (double easting = drawBounds.getMinLongitude(); easting <= drawBounds.getMaxLongitude(); easting += (double)precision) {
                for (double northing = drawBounds.getMinLatitude(); northing <= drawBounds.getMaxLatitude(); northing += (double)precision) {
                    Label label = this.getLabel(gridType, zone, easting, northing);
                    if (label == null) continue;
                    labels.add(label);
                }
            }
        }
        return labels;
    }

    private Label getLabel(GridType gridType, GridZone zone, double easting, double northing) {
        Label label = null;
        int precision = gridType.getPrecision();
        Bounds bounds = zone.getBounds();
        int zoneNumber = zone.getNumber();
        Hemisphere hemisphere = zone.getHemisphere();
        Point northwest = Point.create(zoneNumber, hemisphere, easting, northing + (double)precision);
        Point southwest = Point.create(zoneNumber, hemisphere, easting, northing);
        Point southeast = Point.create(zoneNumber, hemisphere, easting + (double)precision, northing);
        Point northeast = Point.create(zoneNumber, hemisphere, easting + (double)precision, northing + (double)precision);
        double minLatitude = Math.max(southwest.getLatitude(), southeast.getLatitude());
        minLatitude = Math.max(minLatitude, bounds.getMinLatitude());
        double maxLatitude = Math.min(northwest.getLatitude(), northeast.getLatitude());
        maxLatitude = Math.min(maxLatitude, bounds.getMaxLatitude());
        double minLongitude = Math.max(southwest.getLongitude(), northwest.getLongitude());
        minLongitude = Math.max(minLongitude, bounds.getMinLongitude());
        double maxLongitude = Math.min(southeast.getLongitude(), northeast.getLongitude());
        if (minLongitude <= (maxLongitude = Math.min(maxLongitude, bounds.getMaxLongitude())) && minLatitude <= maxLatitude) {
            Bounds labelBounds = Bounds.degrees(minLongitude, minLatitude, maxLongitude, maxLatitude);
            Point center = labelBounds.getCenter();
            MGRS mgrs = center.toMGRS();
            String id = null;
            id = gridType == GridType.HUNDRED_KILOMETER ? mgrs.getColumnRowId() : mgrs.getEastingAndNorthing(gridType);
            label = new Label(id, center, labelBounds, zoneNumber, zone.getLetter());
        }
        return label;
    }
}

