/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.grid;

public enum GridType {
    GZD(0),
    HUNDRED_KILOMETER(100000),
    TEN_KILOMETER(10000),
    KILOMETER(1000),
    HUNDRED_METER(100),
    TEN_METER(10),
    METER(1);

    private int precision;

    private GridType(int precision) {
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getAccuracy() {
        return Math.max(this.ordinal() - 1, 0);
    }

    public static GridType withAccuracy(int accuracy) {
        if (accuracy < 0 || accuracy > 5) {
            throw new IllegalArgumentException("Grid Type accuracy digits must be >= 0 and <= 5. accuracy digits: " + accuracy);
        }
        return GridType.values()[accuracy + 1];
    }

    public static GridType getPrecision(double value) {
        GridType precision = null;
        precision = value % (double)GridType.HUNDRED_KILOMETER.precision == 0.0 ? HUNDRED_KILOMETER : (value % (double)GridType.TEN_KILOMETER.precision == 0.0 ? TEN_KILOMETER : (value % (double)GridType.KILOMETER.precision == 0.0 ? KILOMETER : (value % (double)GridType.HUNDRED_METER.precision == 0.0 ? HUNDRED_METER : (value % (double)GridType.TEN_METER.precision == 0.0 ? TEN_METER : METER))));
        return precision;
    }
}

