/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.grid;

import java.util.List;
import mil.nga.mgrs.color.Color;
import mil.nga.mgrs.features.Bounds;
import mil.nga.mgrs.grid.GridType;
import mil.nga.mgrs.grid.Label;
import mil.nga.mgrs.gzd.GridZone;
import mil.nga.mgrs.property.MGRSProperties;

public abstract class Labeler {
    public static final double DEFAULT_TEXT_SIZE = MGRSProperties.getDoubleProperty("labeler", "text_size");
    public static final double DEFAULT_BUFFER = MGRSProperties.getDoubleProperty("labeler", "buffer");
    private boolean enabled;
    private int minZoom;
    private Integer maxZoom;
    private Color color;
    private double textSize;
    private double buffer;

    public Labeler() {
        this.enabled = true;
        this.minZoom = 0;
        this.color = Color.black();
        this.textSize = DEFAULT_TEXT_SIZE;
        this.buffer = DEFAULT_BUFFER;
    }

    public Labeler(int minZoom, Color color) {
        this(minZoom, color, DEFAULT_TEXT_SIZE);
    }

    public Labeler(int minZoom, Color color, double textSize) {
        this(minZoom, color, textSize, DEFAULT_BUFFER);
    }

    public Labeler(int minZoom, Color color, double textSize, double buffer) {
        this(minZoom, null, color, textSize, buffer);
    }

    public Labeler(int minZoom, Integer maxZoom, Color color) {
        this(minZoom, maxZoom, color, DEFAULT_TEXT_SIZE);
    }

    public Labeler(int minZoom, Integer maxZoom, Color color, double textSize) {
        this(minZoom, maxZoom, color, textSize, DEFAULT_BUFFER);
    }

    public Labeler(int minZoom, Integer maxZoom, Color color, double textSize, double buffer) {
        this(true, minZoom, maxZoom, color, textSize, buffer);
    }

    public Labeler(boolean enabled, int minZoom, Integer maxZoom, Color color) {
        this(enabled, minZoom, maxZoom, color, DEFAULT_TEXT_SIZE);
    }

    public Labeler(boolean enabled, int minZoom, Integer maxZoom, Color color, double textSize) {
        this(enabled, minZoom, maxZoom, color, textSize, DEFAULT_BUFFER);
    }

    public Labeler(boolean enabled, int minZoom, Integer maxZoom, Color color, double textSize, double buffer) {
        this.enabled = enabled;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.color = color;
        this.textSize = textSize;
        this.buffer = buffer;
    }

    public abstract List<Label> getLabels(Bounds var1, GridType var2, GridZone var3);

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public Integer getMaxZoom() {
        return this.maxZoom;
    }

    public boolean hasMaxZoom() {
        return this.maxZoom != null;
    }

    public void setMaxZoom(Integer maxZoom) {
        this.maxZoom = maxZoom;
    }

    public boolean isWithin(int zoom) {
        return zoom >= this.minZoom && (this.maxZoom == null || zoom <= this.maxZoom);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getTextSize() {
        return this.textSize;
    }

    public void setTextSize(double textSize) {
        this.textSize = textSize;
    }

    public double getBuffer() {
        return this.buffer;
    }

    public void setBuffer(double buffer) {
        if (buffer < 0.0 || buffer >= 0.5) {
            throw new IllegalArgumentException("Grid zone edge buffer must be >= 0 and < 0.5. buffer: " + buffer);
        }
        this.buffer = buffer;
    }
}

