/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.gzd;

import java.util.ArrayList;
import java.util.List;
import mil.nga.mgrs.MGRSUtils;
import mil.nga.mgrs.features.Bounds;
import mil.nga.mgrs.features.Line;
import mil.nga.mgrs.features.Point;
import mil.nga.mgrs.grid.GridType;
import mil.nga.mgrs.gzd.LatitudeBand;
import mil.nga.mgrs.gzd.LongitudinalStrip;
import mil.nga.mgrs.utm.Hemisphere;
import mil.nga.mgrs.utm.UTM;

public class GridZone {
    private LongitudinalStrip strip;
    private LatitudeBand band;
    private Bounds bounds;

    public GridZone(LongitudinalStrip strip, LatitudeBand band) {
        this.strip = strip;
        this.band = band;
        this.bounds = Bounds.bounds(strip, band);
    }

    public LongitudinalStrip getStrip() {
        return this.strip;
    }

    public LatitudeBand getBand() {
        return this.band;
    }

    public int getNumber() {
        return this.strip.getNumber();
    }

    public char getLetter() {
        return this.band.getLetter();
    }

    public Hemisphere getHemisphere() {
        return this.band.getHemisphere();
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public String getName() {
        return MGRSUtils.getLabelName(this.getNumber(), this.getLetter());
    }

    public boolean isWithin(Bounds bounds) {
        bounds = bounds.toUnit(this.bounds.getUnit());
        return this.bounds.getSouth() <= bounds.getNorth() && this.bounds.getNorth() >= bounds.getSouth() && this.bounds.getWest() <= bounds.getEast() && this.bounds.getEast() >= bounds.getWest();
    }

    public int getStripExpand() {
        return this.strip.getExpand();
    }

    public List<Line> getLines(GridType gridType) {
        return this.getLines(this.bounds, gridType);
    }

    public List<Line> getLines(Bounds tileBounds, GridType gridType) {
        List<Line> lines = null;
        if (gridType == GridType.GZD) {
            lines = this.bounds.getLines();
        } else {
            Bounds drawBounds = this.getDrawBounds(tileBounds, gridType);
            if (drawBounds != null) {
                lines = new ArrayList<Line>();
                int precision = gridType.getPrecision();
                int zoneNumber = this.getNumber();
                Hemisphere hemisphere = this.getHemisphere();
                double minLon = this.bounds.getMinLongitude();
                double maxLon = this.bounds.getMaxLongitude();
                for (double easting = drawBounds.getMinLongitude(); easting < drawBounds.getMaxLongitude(); easting += (double)precision) {
                    GridType eastingPrecision = GridType.getPrecision(easting);
                    for (double northing = drawBounds.getMinLatitude(); northing < drawBounds.getMaxLatitude(); northing += (double)precision) {
                        GridType northingPrecision = GridType.getPrecision(northing);
                        Point southwest = Point.create(zoneNumber, hemisphere, easting, northing);
                        Point northwest = Point.create(zoneNumber, hemisphere, easting, northing + (double)precision);
                        Point southeast = Point.create(zoneNumber, hemisphere, easting + (double)precision, northing);
                        if (precision > 1) {
                            if (southwest.getLongitude() < minLon) {
                                southwest = this.getWestBoundsPoint(easting, northing, southwest, southeast);
                            } else if (southeast.getLongitude() > maxLon) {
                                southeast = this.getEastBoundsPoint(easting, northing, southwest, southeast);
                            }
                        }
                        lines.add(Line.line(southwest, northwest, eastingPrecision));
                        lines.add(Line.line(southwest, southeast, northingPrecision));
                    }
                }
            }
        }
        return lines;
    }

    private Point getWestBoundsPoint(double easting, double northing, Point west, Point east) {
        return this.getBoundsPoint(easting, northing, west, east, false);
    }

    private Point getEastBoundsPoint(double easting, double northing, Point west, Point east) {
        return this.getBoundsPoint(easting, northing, west, east, true);
    }

    private Point getBoundsPoint(double easting, double northing, Point west, Point east, boolean eastern) {
        Line line = Line.line(west, east);
        Line boundsLine = eastern ? this.bounds.getEastLine() : this.bounds.getWestLine();
        int zoneNumber = this.getNumber();
        Hemisphere hemisphere = this.getHemisphere();
        Point intersection = MGRSUtils.intersection(line, boundsLine);
        UTM intersectionUTM = UTM.from(intersection, zoneNumber, hemisphere);
        double intersectionEasting = intersectionUTM.getEasting();
        double boundsEasting = intersectionEasting - easting;
        boundsEasting = eastern ? Math.ceil(boundsEasting) : Math.floor(boundsEasting);
        Point boundsPoint = Point.create(zoneNumber, hemisphere, easting + boundsEasting, northing);
        return boundsPoint;
    }

    public Bounds getDrawBounds(Bounds tileBounds, GridType gridType) {
        Bounds drawBounds = null;
        if (!(tileBounds = tileBounds.toDegrees().overlap(this.bounds)).isEmpty()) {
            int zoneNumber = this.getNumber();
            Hemisphere hemisphere = this.getHemisphere();
            UTM upperLeftUTM = UTM.from(tileBounds.getNorthwest(), zoneNumber, hemisphere);
            UTM lowerLeftUTM = UTM.from(tileBounds.getSouthwest(), zoneNumber, hemisphere);
            UTM lowerRightUTM = UTM.from(tileBounds.getSoutheast(), zoneNumber, hemisphere);
            UTM upperRightUTM = UTM.from(tileBounds.getNortheast(), zoneNumber, hemisphere);
            int precision = gridType.getPrecision();
            double leftEasting = Math.floor(Math.min(upperLeftUTM.getEasting(), lowerLeftUTM.getEasting()) / (double)precision) * (double)precision;
            double lowerNorthing = Math.floor(Math.min(lowerLeftUTM.getNorthing(), lowerRightUTM.getNorthing()) / (double)precision) * (double)precision;
            double rightEasting = Math.ceil(Math.max(lowerRightUTM.getEasting(), upperRightUTM.getEasting()) / (double)precision) * (double)precision;
            double upperNorthing = Math.ceil(Math.max(upperRightUTM.getNorthing(), upperLeftUTM.getNorthing()) / (double)precision) * (double)precision;
            drawBounds = Bounds.meters(leftEasting, lowerNorthing, rightEasting, upperNorthing);
        }
        return drawBounds;
    }
}

