/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.tile;

import mil.nga.mgrs.MGRSUtils;
import mil.nga.mgrs.features.Bounds;
import mil.nga.mgrs.features.Point;
import mil.nga.mgrs.features.Unit;
import mil.nga.mgrs.tile.Pixel;

public class MGRSTile {
    private int width;
    private int height;
    private int zoom;
    private Bounds bounds;

    public static MGRSTile create(int width, int height, int x, int y, int zoom) {
        return new MGRSTile(width, height, x, y, zoom);
    }

    public static MGRSTile create(int width, int height, Bounds bounds) {
        return new MGRSTile(width, height, bounds);
    }

    public MGRSTile(int width, int height, int x, int y, int zoom) {
        this.width = width;
        this.height = height;
        this.zoom = zoom;
        this.bounds = MGRSUtils.getBounds(x, y, zoom);
    }

    public MGRSTile(int width, int height, Bounds bounds) {
        this.width = width;
        this.height = height;
        this.bounds = bounds;
        this.zoom = (int)Math.round(MGRSUtils.getZoomLevel(bounds));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getZoom() {
        return this.zoom;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public Bounds getBounds(Unit unit) {
        return this.bounds.toUnit(unit);
    }

    public Bounds getBoundsDegrees() {
        return this.getBounds(Unit.DEGREE);
    }

    public Bounds getBoundsMeters() {
        return this.getBounds(Unit.METER);
    }

    public Pixel getPixel(Point point) {
        return MGRSUtils.getPixel(this.width, this.height, this.bounds, point);
    }

    public float getXPixel(double longitude) {
        return MGRSUtils.getXPixel(this.width, this.bounds, longitude);
    }

    public float getYPixel(double latitude) {
        return MGRSUtils.getYPixel(this.height, this.bounds, latitude);
    }
}

