/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.utm;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.nga.mgrs.MGRS;
import mil.nga.mgrs.features.Point;
import mil.nga.mgrs.utm.Hemisphere;

public class UTM {
    private int zone;
    private Hemisphere hemisphere;
    private double easting;
    private double northing;
    private static final Pattern utmPattern = Pattern.compile("^(\\d{1,2})\\s*([N|S])\\s*(\\d+\\.?\\d*)\\s*(\\d+\\.?\\d*)$", 2);

    public static UTM create(int zone, Hemisphere hemisphere, double easting, double northing) {
        return new UTM(zone, hemisphere, easting, northing);
    }

    public UTM(int zone, Hemisphere hemisphere, double easting, double northing) {
        this.zone = zone;
        this.hemisphere = hemisphere;
        this.easting = easting;
        this.northing = northing;
    }

    public int getZone() {
        return this.zone;
    }

    public Hemisphere getHemisphere() {
        return this.hemisphere;
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public Point toPoint() {
        return Point.from(this);
    }

    public MGRS toMGRS() {
        return this.toPoint().toMGRS();
    }

    public String format() {
        StringBuilder value = new StringBuilder();
        DecimalFormat formatter = new DecimalFormat("0.##");
        value.append(String.format("%02d", this.zone));
        value.append(" ");
        value.append(this.hemisphere == Hemisphere.NORTH ? "N" : "S");
        value.append(" ");
        value.append(formatter.format(this.easting));
        value.append(" ");
        value.append(formatter.format(this.northing));
        return value.toString();
    }

    public String toString() {
        return this.format();
    }

    public static boolean isUTM(String utm) {
        return utmPattern.matcher(utm).matches();
    }

    public static UTM parse(String utm) throws ParseException {
        Matcher matcher = utmPattern.matcher(utm);
        if (!matcher.matches()) {
            throw new ParseException("Invalid UTM: " + utm, 0);
        }
        int zone = Integer.parseInt(matcher.group(1));
        Hemisphere hemisphere = matcher.group(2).equalsIgnoreCase("N") ? Hemisphere.NORTH : Hemisphere.SOUTH;
        double easting = Double.parseDouble(matcher.group(3));
        double northing = Double.parseDouble(matcher.group(4));
        return UTM.create(zone, hemisphere, easting, northing);
    }

    public static UTM from(Point latLng) {
        return UTM.from(latLng, latLng.getZoneNumber());
    }

    public static UTM from(Point latLng, int zone) {
        return UTM.from(latLng, zone, latLng.getHemisphere());
    }

    public static UTM from(Point latLng, int zone, Hemisphere hemisphere) {
        latLng = latLng.toDegrees();
        double latitude = latLng.getLatitude();
        double longitude = latLng.getLongitude();
        double easting = 0.5 * Math.log((1.0 + Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0)) / (1.0 - Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0))) * 0.9996 * 6399593.62 / Math.pow(1.0 + Math.pow(0.0820944379, 2.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0), 0.5) * (1.0 + Math.pow(0.0820944379, 2.0) / 2.0 * Math.pow(0.5 * Math.log((1.0 + Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0)) / (1.0 - Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0))), 2.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0) / 3.0) + 500000.0;
        easting = (double)Math.round(easting * 100.0) * 0.01;
        double northing = (Math.atan(Math.tan(latitude * Math.PI / 180.0) / Math.cos(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0)) - latitude * Math.PI / 180.0) * 0.9996 * 6399593.625 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) * (1.0 + 0.003369748371 * Math.pow(0.5 * Math.log((1.0 + Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0)) / (1.0 - Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0))), 2.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) + 6397033.7875500005 * (latitude * Math.PI / 180.0 - 0.005054622556 * (latitude * Math.PI / 180.0 + Math.sin(2.0 * latitude * Math.PI / 180.0) / 2.0) + 4.258201531E-5 * (3.0 * (latitude * Math.PI / 180.0 + Math.sin(2.0 * latitude * Math.PI / 180.0) / 2.0) + Math.sin(2.0 * latitude * Math.PI / 180.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) / 4.0 - 1.674057895E-7 * (5.0 * (3.0 * (latitude * Math.PI / 180.0 + Math.sin(2.0 * latitude * Math.PI / 180.0) / 2.0) + Math.sin(2.0 * latitude * Math.PI / 180.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) / 4.0 + Math.sin(2.0 * latitude * Math.PI / 180.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) / 3.0);
        if (hemisphere == Hemisphere.SOUTH) {
            northing += 1.0E7;
        }
        northing = (double)Math.round(northing * 100.0) * 0.01;
        return UTM.create(zone, hemisphere, easting, northing);
    }
}

