/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.grid;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mil.nga.color.Color;
import mil.nga.grid.BaseGrid;
import mil.nga.grid.GridStyle;
import mil.nga.grid.Labeler;
import mil.nga.grid.features.Bounds;
import mil.nga.grid.tile.GridTile;
import mil.nga.mgrs.features.GridLine;
import mil.nga.mgrs.grid.GridLabel;
import mil.nga.mgrs.grid.GridLabeler;
import mil.nga.mgrs.grid.GridType;
import mil.nga.mgrs.gzd.GridZone;
import mil.nga.mgrs.property.MGRSProperties;

public class Grid
extends BaseGrid
implements Comparable<Grid> {
    public static final double DEFAULT_WIDTH = MGRSProperties.getInstance().getDoubleProperty(new String[]{"grid", "width"});
    private final GridType type;
    private Map<GridType, GridStyle> styles = new HashMap<GridType, GridStyle>();

    protected Grid(GridType type) {
        this.type = type;
    }

    public GridType getType() {
        return this.type;
    }

    public boolean isType(GridType type) {
        return this.type == type;
    }

    public int getPrecision() {
        return this.type.getPrecision();
    }

    public GridStyle getStyle(GridType gridType) {
        GridStyle style = null;
        style = gridType == this.type ? this.getStyle() : this.styles.get((Object)gridType);
        return style;
    }

    private GridStyle getOrCreateStyle(GridType gridType) {
        GridStyle style = this.getStyle(gridType);
        if (style == null) {
            style = new GridStyle();
            this.setStyle(gridType, style);
        }
        return style;
    }

    public void setStyle(GridType gridType, GridStyle style) {
        if (gridType.getPrecision() < this.getPrecision()) {
            throw new IllegalArgumentException("Grid can not define a style for a higher precision grid type. Type: " + this.type + ", Style Type: " + gridType);
        }
        if (gridType == this.type) {
            this.setStyle(style);
        } else {
            this.styles.put(gridType, style != null ? style : new GridStyle());
        }
    }

    public void clearPrecisionStyles() {
        this.styles.clear();
    }

    public Color getColor(GridType gridType) {
        Color color = null;
        GridStyle style = this.getStyle(gridType);
        if (style != null) {
            color = style.getColor();
        }
        if (color == null) {
            color = this.getColor();
        }
        return color;
    }

    public void setColor(GridType gridType, Color color) {
        this.getOrCreateStyle(gridType).setColor(color);
    }

    public double getWidth(GridType gridType) {
        double width = 0.0;
        GridStyle style = this.getStyle(gridType);
        if (style != null) {
            width = style.getWidth();
        }
        if (width == 0.0) {
            width = this.getWidth();
        }
        return width;
    }

    public void setWidth(GridType gridType, double width) {
        this.getOrCreateStyle(gridType).setWidth(width);
    }

    public GridLabeler getLabeler() {
        return (GridLabeler)super.getLabeler();
    }

    protected void setLabeler(GridLabeler labeler) {
        super.setLabeler((Labeler)labeler);
    }

    public List<GridLine> getLines(GridTile tile, GridZone zone) {
        return this.getLines(tile.getZoom(), tile.getBounds(), zone);
    }

    public List<GridLine> getLines(int zoom, Bounds tileBounds, GridZone zone) {
        List<GridLine> lines = null;
        if (this.isLinesWithin(zoom)) {
            lines = this.getLines(tileBounds, zone);
        }
        return lines;
    }

    public List<GridLine> getLines(Bounds tileBounds, GridZone zone) {
        return zone.getLines(tileBounds, this.type);
    }

    public List<GridLabel> getLabels(GridTile tile, GridZone zone) {
        return this.getLabels(tile.getZoom(), tile.getBounds(), zone);
    }

    public List<GridLabel> getLabels(int zoom, Bounds tileBounds, GridZone zone) {
        List<GridLabel> labels = null;
        if (this.isLabelerWithin(zoom)) {
            labels = this.getLabeler().getLabels(tileBounds, this.type, zone);
        }
        return labels;
    }

    @Override
    public int compareTo(Grid other) {
        return this.getPrecisionCompare() - other.getPrecisionCompare();
    }

    public int getPrecisionCompare() {
        int precision = this.getPrecision();
        if (precision <= GridType.GZD.getPrecision()) {
            precision = Integer.MAX_VALUE;
        }
        return precision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Grid other = (Grid)obj;
        return this.type == other.type;
    }
}

