/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.grid;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import mil.nga.color.Color;
import mil.nga.grid.BaseGrids;
import mil.nga.grid.GridStyle;
import mil.nga.grid.property.GridProperties;
import mil.nga.mgrs.grid.Grid;
import mil.nga.mgrs.grid.GridLabeler;
import mil.nga.mgrs.grid.GridType;
import mil.nga.mgrs.grid.MGRSLabeler;
import mil.nga.mgrs.grid.ZoomGrids;
import mil.nga.mgrs.gzd.GZDLabeler;
import mil.nga.mgrs.property.MGRSProperties;

public class Grids
extends BaseGrids<Grid, ZoomGrids> {
    private Map<GridType, Grid> grids = new HashMap<GridType, Grid>();

    public static Grids create() {
        return new Grids();
    }

    public static Grids create(GridType ... types) {
        return new Grids(types);
    }

    public static Grids create(Collection<GridType> types) {
        return new Grids(types);
    }

    public static Grids createGZD() {
        return Grids.create(GridType.GZD);
    }

    public Grids() {
        super((GridProperties)MGRSProperties.getInstance());
        this.createGrids();
        this.createZoomGrids();
    }

    public Grids(GridType ... types) {
        this(Arrays.asList(types));
    }

    public Grids(Collection<GridType> types) {
        super((GridProperties)MGRSProperties.getInstance());
        this.createGrids(false);
        for (GridType type : types) {
            this.getGrid(type).setEnabled(true);
        }
        this.createZoomGrids();
    }

    public double getDefaultWidth() {
        return Grid.DEFAULT_WIDTH;
    }

    public Collection<Grid> grids() {
        return this.grids.values();
    }

    protected Grid newGrid(GridType type) {
        return new Grid(type);
    }

    protected ZoomGrids newZoomGrids(int zoom) {
        return new ZoomGrids(zoom);
    }

    private void createGrids() {
        this.createGrids(null);
    }

    private void createGrids(Boolean enabled) {
        Boolean propagate = this.properties.getBooleanProperty(false, new String[]{"grids", "propagate"});
        HashMap<GridType, GridStyle> styles = null;
        if (propagate != null && propagate.booleanValue()) {
            styles = new HashMap<GridType, GridStyle>();
        }
        this.createGrid(GridType.GZD, styles, enabled, new GZDLabeler());
        this.createGrid(GridType.HUNDRED_KILOMETER, styles, enabled, new MGRSLabeler());
        this.createGrid(GridType.TEN_KILOMETER, styles, enabled, new MGRSLabeler());
        this.createGrid(GridType.KILOMETER, styles, enabled, new MGRSLabeler());
        this.createGrid(GridType.HUNDRED_METER, styles, enabled, new MGRSLabeler());
        this.createGrid(GridType.TEN_METER, styles, enabled, new MGRSLabeler());
        this.createGrid(GridType.METER, styles, enabled, new MGRSLabeler());
    }

    private void createGrid(GridType type, Map<GridType, GridStyle> styles, Boolean enabled, GridLabeler labeler) {
        Grid grid = this.newGrid(type);
        String gridKey = type.name().toLowerCase();
        this.loadGrid(grid, gridKey, enabled, labeler);
        if (styles != null) {
            styles.put(type, GridStyle.style((Color)grid.getColor(), (double)grid.getWidth()));
        }
        this.loadGridStyles(grid, styles, gridKey);
        this.grids.put(type, grid);
    }

    private void loadGridStyles(Grid grid, Map<GridType, GridStyle> styles, String gridKey) {
        int precision = grid.getPrecision();
        if (precision < GridType.HUNDRED_KILOMETER.getPrecision()) {
            this.loadGridStyle(grid, styles, gridKey, GridType.HUNDRED_KILOMETER);
        }
        if (precision < GridType.TEN_KILOMETER.getPrecision()) {
            this.loadGridStyle(grid, styles, gridKey, GridType.TEN_KILOMETER);
        }
        if (precision < GridType.KILOMETER.getPrecision()) {
            this.loadGridStyle(grid, styles, gridKey, GridType.KILOMETER);
        }
        if (precision < GridType.HUNDRED_METER.getPrecision()) {
            this.loadGridStyle(grid, styles, gridKey, GridType.HUNDRED_METER);
        }
        if (precision < GridType.TEN_METER.getPrecision()) {
            this.loadGridStyle(grid, styles, gridKey, GridType.TEN_METER);
        }
    }

    private void loadGridStyle(Grid grid, Map<GridType, GridStyle> styles, String gridKey, GridType gridType) {
        GridStyle style;
        String gridKey2 = gridType.name().toLowerCase();
        Color color = this.loadGridStyleColor(gridKey, gridKey2);
        Double width = this.loadGridStyleWidth(gridKey, gridKey2);
        if ((color == null || width == null) && styles != null && (style = styles.get((Object)gridType)) != null) {
            Color styleColor;
            if (color == null && (styleColor = style.getColor()) != null) {
                color = styleColor.copy();
            }
            if (width == null) {
                width = style.getWidth();
            }
        }
        if (color != null || width != null) {
            style = this.getGridStyle(color, width, grid);
            grid.setStyle(gridType, style);
            if (styles != null) {
                styles.put(gridType, style);
            }
        }
    }

    public Grid getGrid(GridType type) {
        return this.grids.get((Object)type);
    }

    public GridType getPrecision(int zoom) {
        return ((ZoomGrids)this.getGrids(zoom)).getPrecision();
    }

    public void setGrids(GridType ... types) {
        this.setGridTypes(Arrays.asList(types));
    }

    public void setGrids(Grid ... grids) {
        this.setGrids(Arrays.asList(grids));
    }

    public void setGridTypes(Collection<GridType> types) {
        HashSet<GridType> disableTypes = new HashSet<GridType>(Arrays.asList(GridType.values()));
        for (GridType gridType : types) {
            this.enable(gridType);
            disableTypes.remove((Object)gridType);
        }
        this.disableTypes(disableTypes);
    }

    public void setGrids(Collection<Grid> grids) {
        HashSet<GridType> disableTypes = new HashSet<GridType>(Arrays.asList(GridType.values()));
        for (Grid grid : grids) {
            this.enable(grid);
            disableTypes.remove((Object)grid.getType());
        }
        this.disableTypes(disableTypes);
    }

    public void enableTypes(GridType ... types) {
        this.enableTypes(Arrays.asList(types));
    }

    public void enableTypes(Collection<GridType> types) {
        for (GridType type : types) {
            this.enable(type);
        }
    }

    public void disableTypes(GridType ... types) {
        this.disableTypes(Arrays.asList(types));
    }

    public void disableTypes(Collection<GridType> types) {
        for (GridType type : types) {
            this.disable(type);
        }
    }

    public boolean isEnabled(GridType type) {
        return this.getGrid(type).isEnabled();
    }

    public void enable(GridType type) {
        this.enable(this.getGrid(type));
    }

    public void disable(GridType type) {
        this.disable(this.getGrid(type));
    }

    public void setMinZoom(GridType type, int minZoom) {
        this.setMinZoom(this.getGrid(type), minZoom);
    }

    public void setMaxZoom(GridType type, Integer maxZoom) {
        this.setMaxZoom(this.getGrid(type), maxZoom);
    }

    public void setZoomRange(GridType type, int minZoom, Integer maxZoom) {
        this.setZoomRange(this.getGrid(type), minZoom, maxZoom);
    }

    public void setLinesMinZoom(GridType type, Integer minZoom) {
        this.getGrid(type).setLinesMinZoom(minZoom);
    }

    public void setLinesMaxZoom(GridType type, Integer maxZoom) {
        this.getGrid(type).setLinesMaxZoom(maxZoom);
    }

    public void setAllColors(Color color) {
        this.setColor(color, GridType.values());
    }

    public void setColor(Color color, GridType ... types) {
        this.setColor(Arrays.asList(types), color);
    }

    public void setColor(Collection<GridType> types, Color color) {
        for (GridType type : types) {
            this.setColor(type, color);
        }
    }

    public void setColor(GridType type, Color color) {
        this.getGrid(type).setColor(color);
    }

    public void setAllWidths(double width) {
        this.setWidth(width, GridType.values());
    }

    public void setWidth(double width, GridType ... types) {
        this.setWidth(Arrays.asList(types), width);
    }

    public void setWidth(Collection<GridType> types, double width) {
        for (GridType type : types) {
            this.setWidth(type, width);
        }
    }

    public void setWidth(GridType type, double width) {
        this.getGrid(type).setWidth(width);
    }

    public void deletePropagatedStyles() {
        this.deletePropagatedStyles(GridType.values());
    }

    public void deletePropagatedStyles(GridType ... types) {
        this.deletePropagatedStyles(Arrays.asList(types));
    }

    public void deletePropagatedStyles(Collection<GridType> types) {
        for (GridType type : types) {
            this.deletePropagatedStyles(type);
        }
    }

    public void deletePropagatedStyles(GridType type) {
        this.getGrid(type).clearPrecisionStyles();
    }

    public void setColor(Collection<GridType> types, GridType precisionType, Color color) {
        for (GridType type : types) {
            this.setColor(type, precisionType, color);
        }
    }

    public void setColor(GridType type, Color color, GridType ... precisionTypes) {
        this.setColor(type, Arrays.asList(precisionTypes), color);
    }

    public void setColor(GridType type, Collection<GridType> precisionTypes, Color color) {
        for (GridType precisionType : precisionTypes) {
            this.setColor(type, precisionType, color);
        }
    }

    public void setColor(GridType type, GridType precisionType, Color color) {
        this.getGrid(type).setColor(precisionType, color);
    }

    public void setWidth(Collection<GridType> types, GridType precisionType, double width) {
        for (GridType type : types) {
            this.setWidth(type, precisionType, width);
        }
    }

    public void setWidth(GridType type, double width, GridType ... precisionTypes) {
        this.setWidth(type, Arrays.asList(precisionTypes), width);
    }

    public void setWidth(GridType type, Collection<GridType> precisionTypes, double width) {
        for (GridType precisionType : precisionTypes) {
            this.setWidth(type, precisionType, width);
        }
    }

    public void setWidth(GridType type, GridType precisionType, double width) {
        this.getGrid(type).setWidth(precisionType, width);
    }

    public GridLabeler getLabeler(GridType type) {
        return this.getGrid(type).getLabeler();
    }

    public boolean hasLabeler(GridType type) {
        return this.getGrid(type).hasLabeler();
    }

    public void setLabeler(GridType type, GridLabeler labeler) {
        this.getGrid(type).setLabeler(labeler);
    }

    public void disableAllLabelers() {
        this.disableLabelers(GridType.values());
    }

    public void enableLabelers(GridType ... types) {
        this.enableLabelers(Arrays.asList(types));
    }

    public void enableLabelers(Collection<GridType> types) {
        for (GridType type : types) {
            this.enableLabeler(type);
        }
    }

    public void disableLabelers(GridType ... types) {
        this.disableLabelers(Arrays.asList(types));
    }

    public void disableLabelers(Collection<GridType> types) {
        for (GridType type : types) {
            this.disableLabeler(type);
        }
    }

    public boolean isLabelerEnabled(GridType type) {
        GridLabeler labeler = this.getLabeler(type);
        return labeler != null && labeler.isEnabled();
    }

    public void enableLabeler(GridType type) {
        this.getRequiredLabeler(type).setEnabled(true);
    }

    public void disableLabeler(GridType type) {
        GridLabeler labeler = this.getLabeler(type);
        if (labeler != null) {
            labeler.setEnabled(false);
        }
    }

    private GridLabeler getRequiredLabeler(GridType type) {
        GridLabeler labeler = this.getLabeler(type);
        if (labeler == null) {
            throw new IllegalStateException("Grid type does not have a labeler: " + type);
        }
        return labeler;
    }

    public void setLabelMinZoom(GridType type, int minZoom) {
        GridLabeler labeler = this.getRequiredLabeler(type);
        labeler.setMinZoom(minZoom);
        Integer maxZoom = labeler.getMaxZoom();
        if (maxZoom != null && maxZoom < minZoom) {
            labeler.setMaxZoom(minZoom);
        }
    }

    public void setLabelMaxZoom(GridType type, Integer maxZoom) {
        GridLabeler labeler = this.getRequiredLabeler(type);
        labeler.setMaxZoom(maxZoom);
        if (maxZoom != null && labeler.getMinZoom() > maxZoom) {
            labeler.setMinZoom(maxZoom);
        }
    }

    public void setLabelZoomRange(GridType type, int minZoom, Integer maxZoom) {
        GridLabeler labeler = this.getRequiredLabeler(type);
        if (maxZoom != null && maxZoom < minZoom) {
            throw new IllegalArgumentException("Min zoom '" + minZoom + "' can not be larger than max zoom '" + maxZoom + "'");
        }
        labeler.setMinZoom(minZoom);
        labeler.setMaxZoom(maxZoom);
    }

    public void setLabelBuffer(double buffer, GridType ... types) {
        this.setLabelBuffer(Arrays.asList(types), buffer);
    }

    public void setLabelBuffer(Collection<GridType> types, double buffer) {
        for (GridType type : types) {
            this.setLabelBuffer(type, buffer);
        }
    }

    public double getLabelBuffer(GridType type) {
        return this.getGrid(type).getLabelBuffer();
    }

    public void setLabelBuffer(GridType type, double buffer) {
        this.getRequiredLabeler(type).setBuffer(buffer);
    }

    public void setAllLabelColors(Color color) {
        for (Grid grid : this.grids.values()) {
            if (!grid.hasLabeler()) continue;
            this.setLabelColor(grid.getType(), color);
        }
    }

    public void setLabelColor(Color color, GridType ... types) {
        this.setLabelColor(Arrays.asList(types), color);
    }

    public void setLabelColor(Collection<GridType> types, Color color) {
        for (GridType type : types) {
            this.setLabelColor(type, color);
        }
    }

    public void setLabelColor(GridType type, Color color) {
        this.getRequiredLabeler(type).setColor(color);
    }

    public void setAllLabelTextSizes(double textSize) {
        for (Grid grid : this.grids.values()) {
            if (!grid.hasLabeler()) continue;
            this.setLabelTextSize(grid.getType(), textSize);
        }
    }

    public void setLabelTextSize(double textSize, GridType ... types) {
        this.setLabelTextSize(Arrays.asList(types), textSize);
    }

    public void setLabelTextSize(Collection<GridType> types, double textSize) {
        for (GridType type : types) {
            this.setLabelTextSize(type, textSize);
        }
    }

    public void setLabelTextSize(GridType type, double textSize) {
        this.getRequiredLabeler(type).setTextSize(textSize);
    }
}

