/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs;

import mil.nga.grid.GridUtils;
import mil.nga.grid.Hemisphere;

public class MGRSUtils {
    public static void validateZoneNumber(int number) {
        if (number < 1 || number > 60) {
            throw new IllegalArgumentException("Illegal zone number (expected 1 - 60): " + number);
        }
    }

    public static void validateBandLetter(char letter) {
        if (letter < 'C' || letter > 'X' || GridUtils.isOmittedBandLetter((char)letter)) {
            throw new IllegalArgumentException("Illegal band letter (CDEFGHJKLMNPQRSTUVWX): " + letter);
        }
    }

    public static char nextBandLetter(char letter) {
        MGRSUtils.validateBandLetter(letter);
        letter = (char)(letter + '\u0001');
        if (GridUtils.isOmittedBandLetter((char)letter)) {
            letter = (char)(letter + '\u0001');
        }
        return letter;
    }

    public static char previousBandLetter(char letter) {
        MGRSUtils.validateBandLetter(letter);
        letter = (char)(letter - '\u0001');
        if (GridUtils.isOmittedBandLetter((char)letter)) {
            letter = (char)(letter - '\u0001');
        }
        return letter;
    }

    public static String getLabelName(int zoneNumber, char bandLetter) {
        return String.valueOf(zoneNumber) + bandLetter;
    }

    public static Hemisphere getHemisphere(char bandLetter) {
        return bandLetter < 'N' ? Hemisphere.SOUTH : Hemisphere.NORTH;
    }
}

