/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.grid;

import java.util.ArrayList;
import java.util.List;
import mil.nga.color.Color;
import mil.nga.grid.Hemisphere;
import mil.nga.grid.features.Bounds;
import mil.nga.grid.features.Point;
import mil.nga.mgrs.MGRS;
import mil.nga.mgrs.grid.GridLabel;
import mil.nga.mgrs.grid.GridLabeler;
import mil.nga.mgrs.grid.GridType;
import mil.nga.mgrs.gzd.GridZone;
import mil.nga.mgrs.utm.UTM;

public class MGRSLabeler
extends GridLabeler {
    public MGRSLabeler() {
    }

    public MGRSLabeler(int minZoom, Color color) {
        super(minZoom, color);
    }

    public MGRSLabeler(int minZoom, Color color, double textSize) {
        super(minZoom, color, textSize);
    }

    public MGRSLabeler(int minZoom, Color color, double textSize, double buffer) {
        super(minZoom, color, textSize, buffer);
    }

    public MGRSLabeler(int minZoom, Integer maxZoom, Color color) {
        super(minZoom, maxZoom, color);
    }

    public MGRSLabeler(int minZoom, Integer maxZoom, Color color, double textSize) {
        super(minZoom, maxZoom, color, textSize);
    }

    public MGRSLabeler(int minZoom, Integer maxZoom, Color color, double textSize, double buffer) {
        super(minZoom, maxZoom, color, textSize, buffer);
    }

    public MGRSLabeler(boolean enabled, int minZoom, Integer maxZoom, Color color) {
        super(enabled, minZoom, maxZoom, color);
    }

    public MGRSLabeler(boolean enabled, int minZoom, Integer maxZoom, Color color, double textSize) {
        super(enabled, minZoom, maxZoom, color, textSize);
    }

    public MGRSLabeler(boolean enabled, int minZoom, Integer maxZoom, Color color, double textSize, double buffer) {
        super(enabled, minZoom, maxZoom, color, textSize, buffer);
    }

    @Override
    public List<GridLabel> getLabels(Bounds tileBounds, GridType gridType, GridZone zone) {
        ArrayList<GridLabel> labels = null;
        Bounds drawBounds = zone.getDrawBounds(tileBounds, gridType);
        if (drawBounds != null) {
            labels = new ArrayList<GridLabel>();
            int precision = gridType.getPrecision();
            for (double easting = drawBounds.getMinLongitude(); easting <= drawBounds.getMaxLongitude(); easting += (double)precision) {
                for (double northing = drawBounds.getMinLatitude(); northing <= drawBounds.getMaxLatitude(); northing += (double)precision) {
                    GridLabel label = this.getLabel(gridType, zone, easting, northing);
                    if (label == null) continue;
                    labels.add(label);
                }
            }
        }
        return labels;
    }

    private GridLabel getLabel(GridType gridType, GridZone zone, double easting, double northing) {
        GridLabel label = null;
        int precision = gridType.getPrecision();
        Bounds bounds = zone.getBounds();
        int zoneNumber = zone.getNumber();
        Hemisphere hemisphere = zone.getHemisphere();
        Point northwest = UTM.point(zoneNumber, hemisphere, easting, northing + (double)precision);
        Point southwest = UTM.point(zoneNumber, hemisphere, easting, northing);
        Point southeast = UTM.point(zoneNumber, hemisphere, easting + (double)precision, northing);
        Point northeast = UTM.point(zoneNumber, hemisphere, easting + (double)precision, northing + (double)precision);
        double minLatitude = Math.max(southwest.getLatitude(), southeast.getLatitude());
        minLatitude = Math.max(minLatitude, bounds.getMinLatitude());
        double maxLatitude = Math.min(northwest.getLatitude(), northeast.getLatitude());
        maxLatitude = Math.min(maxLatitude, bounds.getMaxLatitude());
        double minLongitude = Math.max(southwest.getLongitude(), northwest.getLongitude());
        minLongitude = Math.max(minLongitude, bounds.getMinLongitude());
        double maxLongitude = Math.min(southeast.getLongitude(), northeast.getLongitude());
        if (minLongitude <= (maxLongitude = Math.min(maxLongitude, bounds.getMaxLongitude())) && minLatitude <= maxLatitude) {
            Bounds labelBounds = Bounds.degrees((double)minLongitude, (double)minLatitude, (double)maxLongitude, (double)maxLatitude);
            Point center = labelBounds.getCentroid();
            MGRS mgrs = MGRS.from(center);
            String id = null;
            id = gridType == GridType.HUNDRED_KILOMETER ? mgrs.getColumnRowId() : mgrs.getEastingAndNorthing(gridType);
            label = new GridLabel(id, center, labelBounds, gridType, mgrs);
        }
        return label;
    }
}

