/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.gzd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mil.nga.grid.features.Bounds;
import mil.nga.mgrs.MGRSUtils;
import mil.nga.mgrs.gzd.BandLetterRange;
import mil.nga.mgrs.gzd.GridZone;
import mil.nga.mgrs.gzd.GridZones;
import mil.nga.mgrs.gzd.ZoneNumberRange;

public class GridRange
implements Iterable<GridZone> {
    private ZoneNumberRange zoneNumberRange;
    private BandLetterRange bandLetterRange;

    public GridRange() {
        this.zoneNumberRange = new ZoneNumberRange();
        this.bandLetterRange = new BandLetterRange();
    }

    public GridRange(ZoneNumberRange zoneNumberRange, BandLetterRange bandLetterRange) {
        this.zoneNumberRange = zoneNumberRange;
        this.bandLetterRange = bandLetterRange;
    }

    public ZoneNumberRange getZoneNumberRange() {
        return this.zoneNumberRange;
    }

    public void setZoneNumberRange(ZoneNumberRange zoneNumberRange) {
        this.zoneNumberRange = zoneNumberRange;
    }

    public BandLetterRange getBandLetterRange() {
        return this.bandLetterRange;
    }

    public void setBandLetterRange(BandLetterRange bandLetterRange) {
        this.bandLetterRange = bandLetterRange;
    }

    public Bounds getBounds() {
        double west = this.zoneNumberRange.getWestLongitude();
        double south = this.bandLetterRange.getSouthLatitude();
        double east = this.zoneNumberRange.getEastLongitude();
        double north = this.bandLetterRange.getNorthLatitude();
        return Bounds.degrees((double)west, (double)south, (double)east, (double)north);
    }

    @Override
    public Iterator<GridZone> iterator() {
        return new Iterator<GridZone>(){
            private final int minZoneNumber;
            private final int maxZoneNumber;
            private final char minBandLetter;
            private final char maxBandLetter;
            private int zoneNumber;
            private char bandLetter;
            private GridZone gridZone;
            private List<GridZone> additional;
            {
                this.minZoneNumber = GridRange.this.zoneNumberRange.getWest();
                this.maxZoneNumber = GridRange.this.zoneNumberRange.getEast();
                this.minBandLetter = GridRange.this.bandLetterRange.getSouth();
                this.maxBandLetter = GridRange.this.bandLetterRange.getNorth();
                this.zoneNumber = this.minZoneNumber;
                this.bandLetter = this.minBandLetter;
                this.gridZone = null;
                this.additional = new ArrayList<GridZone>();
            }

            @Override
            public boolean hasNext() {
                while (this.gridZone == null && this.zoneNumber <= this.maxZoneNumber) {
                    this.gridZone = GridZones.getGridZone(this.zoneNumber, this.bandLetter);
                    if (this.gridZone == null) {
                        if (this.zoneNumber == this.minZoneNumber) {
                            this.additional.add(GridZones.getGridZone(this.zoneNumber - 1, this.bandLetter));
                        }
                        if (this.zoneNumber == this.maxZoneNumber) {
                            this.additional.add(GridZones.getGridZone(this.zoneNumber + 1, this.bandLetter));
                        }
                    } else {
                        int expand = this.gridZone.getStripExpand();
                        if (expand != 0) {
                            int expandZone;
                            if (expand > 0) {
                                for (expandZone = this.zoneNumber + expand; expandZone > this.zoneNumber && expandZone > this.maxZoneNumber; --expandZone) {
                                    this.additional.add(GridZones.getGridZone(expandZone, this.bandLetter));
                                }
                            } else {
                                for (expandZone = this.zoneNumber + expand; expandZone < this.zoneNumber && expandZone < this.minZoneNumber; ++expandZone) {
                                    this.additional.add(GridZones.getGridZone(expandZone, this.bandLetter));
                                }
                            }
                        }
                    }
                    this.bandLetter = MGRSUtils.nextBandLetter(this.bandLetter);
                    if (this.bandLetter <= this.maxBandLetter) continue;
                    ++this.zoneNumber;
                    this.bandLetter = this.minBandLetter;
                }
                if (this.gridZone == null && !this.additional.isEmpty()) {
                    this.gridZone = this.additional.remove(0);
                }
                return this.gridZone != null;
            }

            @Override
            public GridZone next() {
                GridZone next = this.gridZone;
                this.gridZone = null;
                return next;
            }
        };
    }
}

