/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.proj;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mil.nga.crs.CRS;
import mil.nga.crs.CRSException;
import mil.nga.crs.CompoundCoordinateReferenceSystem;
import mil.nga.crs.SimpleCoordinateReferenceSystem;
import mil.nga.crs.common.Axis;
import mil.nga.crs.common.CoordinateSystem;
import mil.nga.crs.common.Unit;
import mil.nga.crs.common.UnitType;
import mil.nga.crs.common.Units;
import mil.nga.crs.geo.Ellipsoid;
import mil.nga.crs.geo.GeoCoordinateReferenceSystem;
import mil.nga.crs.geo.GeoDatum;
import mil.nga.crs.geo.PrimeMeridian;
import mil.nga.crs.geo.TriaxialEllipsoid;
import mil.nga.crs.operation.OperationMethod;
import mil.nga.crs.operation.OperationParameter;
import mil.nga.crs.projected.MapProjection;
import mil.nga.crs.projected.ProjectedCoordinateReferenceSystem;
import mil.nga.crs.wkt.CRSReader;
import mil.nga.proj.ProjectionException;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.datum.Datum;
import org.locationtech.proj4j.parser.DatumParameters;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.units.DegreeUnit;

public class CRSParser {
    private static final CRSFactory crsFactory = new CRSFactory();
    private static final Map<String, org.locationtech.proj4j.datum.Ellipsoid> ellipsoids = new HashMap<String, org.locationtech.proj4j.datum.Ellipsoid>();

    public static CRSFactory getCRSFactory() {
        return crsFactory;
    }

    public static org.locationtech.proj4j.datum.Ellipsoid getEllipsoid(String name) {
        return ellipsoids.get(name.toLowerCase());
    }

    public static CoordinateReferenceSystem parse(String wkt) {
        CRS crsObject = null;
        try {
            crsObject = CRSReader.read((String)wkt);
        }
        catch (IOException e) {
            throw new ProjectionException("Failed to parse WKT: " + wkt, e);
        }
        CoordinateReferenceSystem crs = null;
        if (crsObject != null) {
            crs = CRSParser.convert(crsObject);
        }
        return crs;
    }

    public static CoordinateReferenceSystem convert(CRS crsObject) {
        CoordinateReferenceSystem crs = null;
        switch (crsObject.getType()) {
            case GEODETIC: 
            case GEOGRAPHIC: {
                crs = CRSParser.convert((GeoCoordinateReferenceSystem)crsObject);
                break;
            }
            case PROJECTED: {
                crs = CRSParser.convert((ProjectedCoordinateReferenceSystem)crsObject);
                break;
            }
            case COMPOUND: {
                crs = CRSParser.convert((CompoundCoordinateReferenceSystem)crsObject);
                break;
            }
        }
        return crs;
    }

    public static CoordinateReferenceSystem convert(GeoCoordinateReferenceSystem geo) {
        GeoDatum geoDatum = geo.getGeoDatum();
        Datum datum = CRSParser.convert(geoDatum);
        Projection projection = CRSParser.createProjection(geo.getCoordinateSystem());
        CRSParser.updateProjection(projection, datum.getEllipsoid(), geoDatum);
        projection.initialize();
        return new CoordinateReferenceSystem(geo.getName(), null, datum, projection);
    }

    public static CoordinateReferenceSystem convert(ProjectedCoordinateReferenceSystem projected) {
        MapProjection mapProjection = projected.getMapProjection();
        GeoDatum geoDatum = projected.getGeoDatum();
        org.locationtech.proj4j.datum.Ellipsoid ellipsoid = CRSParser.convert(geoDatum.getEllipsoid());
        DatumParameters datumParameters = new DatumParameters();
        OperationMethod method = mapProjection.getMethod();
        if (projected.hasIdentifiers() && projected.getIdentifier(0).getNameAndUniqueIdentifier().equalsIgnoreCase("EPSG:3857")) {
            datumParameters.setA(ellipsoid.getA());
            datumParameters.setES(0.0);
        } else {
            datumParameters.setEllipsoid(ellipsoid);
        }
        datumParameters.setDatumTransform(CRSParser.convertDatumTransform(method));
        Datum datum = datumParameters.getDatum();
        Projection projection = CRSParser.createProjection(projected.getCoordinateSystem(), mapProjection);
        CRSParser.updateProjection(projection, datum.getEllipsoid(), geoDatum);
        CRSParser.updateProjection(projection, method);
        projection.initialize();
        return new CoordinateReferenceSystem(projected.getName(), null, datum, projection);
    }

    public static CoordinateReferenceSystem convert(CompoundCoordinateReferenceSystem compound) {
        SimpleCoordinateReferenceSystem simpleCrs;
        CoordinateReferenceSystem crs = null;
        Iterator iterator = compound.getCoordinateReferenceSystems().iterator();
        while (iterator.hasNext() && (crs = CRSParser.convert((CRS)(simpleCrs = (SimpleCoordinateReferenceSystem)iterator.next()))) == null) {
        }
        return crs;
    }

    public static Datum convert(GeoDatum geoDatum) {
        String name = geoDatum.getName();
        org.locationtech.proj4j.datum.Ellipsoid ellipsoid = CRSParser.convert(geoDatum.getEllipsoid());
        String code = name;
        if (geoDatum.hasIdentifiers()) {
            code = geoDatum.getIdentifier(0).getNameAndUniqueIdentifier();
        }
        return new Datum(code, null, null, ellipsoid, name);
    }

    public static org.locationtech.proj4j.datum.Ellipsoid convert(Ellipsoid ellipsoid) {
        String name = ellipsoid.getName();
        org.locationtech.proj4j.datum.Ellipsoid converted = CRSParser.getEllipsoid(name);
        if (converted == null) {
            String shortName = name;
            if (ellipsoid.hasIdentifiers()) {
                shortName = ellipsoid.getIdentifier(0).getNameAndUniqueIdentifier();
            }
            double equatorRadius = ellipsoid.getSemiMajorAxis();
            double poleRadius = 0.0;
            double reciprocalFlattening = 0.0;
            switch (ellipsoid.getType()) {
                case OBLATE: {
                    reciprocalFlattening = ellipsoid.getInverseFlattening();
                    if (reciprocalFlattening != 0.0) break;
                    reciprocalFlattening = Double.POSITIVE_INFINITY;
                    break;
                }
                case TRIAXIAL: {
                    TriaxialEllipsoid triaxial = (TriaxialEllipsoid)ellipsoid;
                    poleRadius = triaxial.getSemiMinorAxis();
                    break;
                }
                default: {
                    throw new CRSException("Unsupported Ellipsoid Type: " + ellipsoid.getType());
                }
            }
            converted = new org.locationtech.proj4j.datum.Ellipsoid(shortName, equatorRadius, poleRadius, reciprocalFlattening, name);
        }
        return converted;
    }

    public static double[] convertDatumTransform(OperationMethod method) {
        double[] transform3 = new double[3];
        double[] transform7 = new double[7];
        boolean param3 = false;
        boolean param7 = false;
        for (OperationParameter parameter : method.getParameters()) {
            if (!parameter.hasParameter()) continue;
            switch (parameter.getParameter()) {
                case X_AXIS_TRANSLATION: {
                    transform3[0] = CRSParser.getValue(parameter, Units.getMetre());
                    param3 = true;
                    break;
                }
                case Y_AXIS_TRANSLATION: {
                    transform3[1] = CRSParser.getValue(parameter, Units.getMetre());
                    param3 = true;
                    break;
                }
                case Z_AXIS_TRANSLATION: {
                    transform3[2] = CRSParser.getValue(parameter, Units.getMetre());
                    param3 = true;
                    break;
                }
                case X_AXIS_ROTATION: {
                    transform7[3] = CRSParser.getValue(parameter, Units.getArcSecond());
                    param7 = true;
                    break;
                }
                case Y_AXIS_ROTATION: {
                    transform7[4] = CRSParser.getValue(parameter, Units.getArcSecond());
                    param7 = true;
                    break;
                }
                case Z_AXIS_ROTATION: {
                    transform7[5] = CRSParser.getValue(parameter, Units.getArcSecond());
                    param7 = true;
                    break;
                }
                case SCALE_DIFFERENCE: {
                    transform7[6] = CRSParser.getValue(parameter, Units.getPartsPerMillion());
                    param7 = true;
                    break;
                }
            }
        }
        double[] transform = null;
        if (param7) {
            transform7[0] = transform3[0];
            transform7[1] = transform3[1];
            transform7[2] = transform3[2];
            transform = transform7;
        } else if (param3) {
            transform = transform3;
        }
        return transform;
    }

    public static void updateProjection(Projection projection, org.locationtech.proj4j.datum.Ellipsoid ellipsoid, GeoDatum geoDatum) {
        projection.setEllipsoid(ellipsoid);
        if (geoDatum.hasPrimeMeridian()) {
            PrimeMeridian primeMeridian = geoDatum.getPrimeMeridian();
            double primeMeridianLongitude = CRSParser.convertValue(primeMeridian.getLongitude(), primeMeridian.getLongitudeUnit(), Units.getDegree());
            projection.setPrimeMeridian(Double.toString(primeMeridianLongitude));
        }
    }

    public static Projection createProjection(CoordinateSystem coordinateSystem) {
        Unit unit = coordinateSystem.getAxisUnit();
        String projectionName = null;
        projectionName = unit != null && (unit.getType() == UnitType.ANGLEUNIT || unit.getType() == UnitType.UNIT && unit.getName().toLowerCase().startsWith("deg")) ? "longlat" : "merc";
        return CRSParser.createProjection(projectionName, coordinateSystem);
    }

    public static Projection createProjection(CoordinateSystem coordinateSystem, MapProjection mapProjection) {
        Projection projection = null;
        OperationMethod method = mapProjection.getMethod();
        if (method.hasMethod()) {
            String projectionName = null;
            switch (method.getMethod()) {
                case ALBERS_EQUAL_AREA: {
                    projectionName = "aea";
                    break;
                }
                case AMERICAN_POLYCONIC: {
                    projectionName = "poly";
                    break;
                }
                case CASSINI_SOLDNER: {
                    projectionName = "cass";
                    break;
                }
                case EQUIDISTANT_CYLINDRICAL: {
                    projectionName = "eqc";
                    break;
                }
                case HOTINE_OBLIQUE_MERCATOR_A: 
                case HOTINE_OBLIQUE_MERCATOR_B: {
                    if (mapProjection.getName().toLowerCase().contains("swiss oblique mercator")) {
                        projectionName = "somerc";
                        break;
                    }
                    projectionName = "omerc";
                    break;
                }
                case KROVAK: {
                    projectionName = "krovak";
                    break;
                }
                case LAMBERT_AZIMUTHAL_EQUAL_AREA: {
                    projectionName = "laea";
                    break;
                }
                case LAMBERT_CONIC_CONFORMAL_1SP: 
                case LAMBERT_CONIC_CONFORMAL_2SP: {
                    projectionName = "lcc";
                    break;
                }
                case LAMBERT_CYLINDRICAL_EQUAL_AREA: {
                    projectionName = "cea";
                    break;
                }
                case MERCATOR_A: 
                case MERCATOR_B: {
                    projectionName = "merc";
                    break;
                }
                case NEW_ZEALAND_MAP_GRID: {
                    projectionName = "nzmg";
                    break;
                }
                case OBLIQUE_STEREOGRAPHIC: {
                    projectionName = "sterea";
                    break;
                }
                case POLAR_STEREOGRAPHIC_A: 
                case POLAR_STEREOGRAPHIC_B: 
                case POLAR_STEREOGRAPHIC_C: {
                    projectionName = "stere";
                    break;
                }
                case POPULAR_VISUALISATION_PSEUDO_MERCATOR: {
                    projectionName = "merc";
                    break;
                }
                case TRANSVERSE_MERCATOR: 
                case TRANSVERSE_MERCATOR_SOUTH_ORIENTATED: {
                    if (mapProjection.getName().toLowerCase().contains("utm zone")) {
                        projectionName = "utm";
                        break;
                    }
                    projectionName = "tmerc";
                    break;
                }
            }
            if (projectionName != null) {
                projection = CRSParser.createProjection(projectionName, coordinateSystem);
                switch (method.getMethod()) {
                    case HOTINE_OBLIQUE_MERCATOR_A: {
                        projection.setNoUoff(true);
                        break;
                    }
                }
            }
        }
        if (projection == null) {
            projection = CRSParser.createProjection(coordinateSystem);
        }
        return projection;
    }

    public static Projection createProjection(String projectionName, CoordinateSystem coordinateSystem) {
        Projection projection = CRSParser.getCRSFactory().getRegistry().getProjection(projectionName);
        String axisOrder = CRSParser.convert(coordinateSystem.getAxes());
        if (axisOrder.equals("wsu")) {
            projection.setAxisOrder(axisOrder);
        }
        return projection;
    }

    public static void updateProjection(Projection projection, OperationMethod method) {
        if (method.hasParameters()) {
            for (OperationParameter parameter : method.getParameters()) {
                CRSParser.updateProjection(projection, method, parameter);
            }
        }
    }

    public static void updateProjection(Projection projection, OperationMethod method, OperationParameter parameter) {
        if (parameter.hasParameter()) {
            block0 : switch (parameter.getParameter()) {
                case FALSE_EASTING: 
                case EASTING_AT_PROJECTION_CENTRE: 
                case EASTING_AT_FALSE_ORIGIN: {
                    projection.setFalseEasting(CRSParser.getValue(parameter, projection.getUnits()));
                    break;
                }
                case FALSE_NORTHING: 
                case NORTHING_AT_PROJECTION_CENTRE: 
                case NORTHING_AT_FALSE_ORIGIN: {
                    projection.setFalseNorthing(CRSParser.getValue(parameter, projection.getUnits()));
                    break;
                }
                case SCALE_FACTOR_AT_NATURAL_ORIGIN: 
                case SCALE_FACTOR_ON_INITIAL_LINE: {
                    projection.setScaleFactor(CRSParser.getValue(parameter, Units.getUnity()));
                    break;
                }
                case LATITUDE_OF_1ST_STANDARD_PARALLEL: {
                    projection.setProjectionLatitude1(CRSParser.getValue(parameter, Units.getRadian()));
                    break;
                }
                case LATITUDE_OF_2ND_STANDARD_PARALLEL: {
                    projection.setProjectionLatitude2(CRSParser.getValue(parameter, Units.getRadian()));
                    break;
                }
                case LATITUDE_OF_PROJECTION_CENTRE: 
                case LATITUDE_OF_NATURAL_ORIGIN: 
                case LATITUDE_OF_FALSE_ORIGIN: {
                    projection.setProjectionLatitude(CRSParser.getValue(parameter, Units.getRadian()));
                    if (!method.hasMethod()) break;
                    switch (method.getMethod()) {
                        case POLAR_STEREOGRAPHIC_A: 
                        case POLAR_STEREOGRAPHIC_B: 
                        case POLAR_STEREOGRAPHIC_C: {
                            projection.setTrueScaleLatitude(projection.getProjectionLatitude());
                            break block0;
                        }
                    }
                    break;
                }
                case LONGITUDE_OF_PROJECTION_CENTRE: 
                case LONGITUDE_OF_NATURAL_ORIGIN: 
                case LONGITUDE_OF_FALSE_ORIGIN: 
                case LONGITUDE_OF_ORIGIN: {
                    if (method.hasMethod()) {
                        switch (method.getMethod()) {
                            case HOTINE_OBLIQUE_MERCATOR_A: 
                            case HOTINE_OBLIQUE_MERCATOR_B: {
                                projection.setLonC(CRSParser.getValue(parameter, Units.getRadian()));
                                break block0;
                            }
                        }
                        projection.setProjectionLongitude(CRSParser.getValue(parameter, Units.getRadian()));
                        break;
                    }
                    projection.setProjectionLongitude(CRSParser.getValue(parameter, Units.getRadian()));
                    break;
                }
                case AZIMUTH_OF_INITIAL_LINE: {
                    projection.setAlpha(CRSParser.getValue(parameter, Units.getRadian()));
                    break;
                }
                case ANGLE_FROM_RECTIFIED_TO_SKEW_GRID: {
                    projection.setGamma(CRSParser.getValue(parameter, Units.getRadian()));
                    break;
                }
            }
        }
    }

    public static String convert(List<Axis> axes) {
        String axisValue = null;
        int axesCount = axes.size();
        if (axesCount == 2 || axesCount == 3) {
            StringBuilder axisString = new StringBuilder();
            for (Axis axis : axes) {
                switch (axis.getDirection()) {
                    case EAST: {
                        axisString.append("e");
                        break;
                    }
                    case WEST: {
                        axisString.append("w");
                        break;
                    }
                    case NORTH: {
                        axisString.append("n");
                        break;
                    }
                    case SOUTH: {
                        axisString.append("s");
                        break;
                    }
                    case UP: {
                        axisString.append("u");
                        break;
                    }
                    case DOWN: {
                        axisString.append("d");
                        break;
                    }
                    default: {
                        axisString = null;
                    }
                }
                if (axisString != null) continue;
                break;
            }
            if (axisString != null) {
                if (axesCount == 2) {
                    axisString.append("u");
                }
                axisValue = axisString.toString();
            }
        }
        return axisValue;
    }

    public static double getValue(OperationParameter parameter, org.locationtech.proj4j.units.Unit unit) {
        Unit desiredUnit = null;
        desiredUnit = unit instanceof DegreeUnit ? Units.getDegree() : Units.getMetre();
        return CRSParser.getValue(parameter, desiredUnit);
    }

    public static double getValue(OperationParameter parameter, Unit unit) {
        return CRSParser.convertValue(parameter.getValue(), parameter.getUnit(), unit);
    }

    public static double convertValue(double value, Unit fromUnit, Unit toUnit) {
        if (fromUnit == null) {
            fromUnit = Units.getDefaultUnit((UnitType)toUnit.getType());
        }
        if (Units.canConvert((Unit)fromUnit, (Unit)toUnit)) {
            value = Units.convert((double)value, (Unit)fromUnit, (Unit)toUnit);
        }
        return value;
    }

    static {
        for (org.locationtech.proj4j.datum.Ellipsoid ellipsoid : org.locationtech.proj4j.datum.Ellipsoid.ellipsoids) {
            ellipsoids.put(ellipsoid.getShortName().toLowerCase(), ellipsoid);
            String name = ellipsoid.getName().toLowerCase();
            ellipsoids.put(name, ellipsoid);
            int index = name.indexOf("(");
            if (index < 0) continue;
            ellipsoids.put(name.substring(0, index).trim(), ellipsoid);
        }
    }
}

