/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.proj;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.crs.CRS;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.wkt.CRSReader;
import mil.nga.proj.AuthorityProjections;
import mil.nga.proj.CRSParser;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionException;
import mil.nga.proj.ProjectionFactoryType;
import mil.nga.proj.ProjectionRetriever;
import mil.nga.proj.Projections;
import org.locationtech.proj4j.CoordinateReferenceSystem;

public class ProjectionFactory {
    private static final Logger logger = Logger.getLogger(ProjectionFactory.class.getName());
    private static final ProjectionFactoryType[] DEFAULT_ORDER = new ProjectionFactoryType[]{ProjectionFactoryType.CACHE, ProjectionFactoryType.DEFINITION, ProjectionFactoryType.PARAMETERS, ProjectionFactoryType.PROPERTIES, ProjectionFactoryType.NAME};
    private static final Projections projections = new Projections();
    private static final Set<ProjectionFactoryType> order = new LinkedHashSet<ProjectionFactoryType>();

    public static void resetOrder() {
        ProjectionFactory.setOrder(DEFAULT_ORDER);
    }

    public static Set<ProjectionFactoryType> getOrder() {
        return new LinkedHashSet<ProjectionFactoryType>(order);
    }

    public static Set<ProjectionFactoryType> getCachelessOrder() {
        Set<ProjectionFactoryType> orderCopy = ProjectionFactory.getOrder();
        orderCopy.remove((Object)ProjectionFactoryType.CACHE);
        return orderCopy;
    }

    public static boolean removeOrderType(ProjectionFactoryType type) {
        boolean removed = order.remove((Object)type);
        if (order.isEmpty()) {
            ProjectionFactory.resetOrder();
        }
        return removed;
    }

    public static void setOrder(ProjectionFactoryType ... types) {
        order.clear();
        if (types == null || types.length == 0) {
            ProjectionFactory.resetOrder();
        } else {
            for (ProjectionFactoryType type : types) {
                order.add(type);
            }
        }
    }

    public static Set<ProjectionFactoryType> buildDefaultOrder() {
        return ProjectionFactory.buildOrder(DEFAULT_ORDER);
    }

    public static Set<ProjectionFactoryType> buildOrder(ProjectionFactoryType ... types) {
        LinkedHashSet<ProjectionFactoryType> tempOrder = new LinkedHashSet<ProjectionFactoryType>();
        for (ProjectionFactoryType type : types) {
            tempOrder.add(type);
        }
        return tempOrder;
    }

    public static Projection getProjection(long epsg) {
        return ProjectionFactory.getProjection("EPSG", String.valueOf(epsg));
    }

    public static Projection getCachelessProjection(long epsg) {
        return ProjectionFactory.getCachelessProjection("EPSG", String.valueOf(epsg));
    }

    public static Projection getProjection(String name) {
        String[] authorityAndCode = ProjectionFactory.parseAuthorityAndCode(name);
        return ProjectionFactory.getProjection(authorityAndCode[0], authorityAndCode[1]);
    }

    public static Projection getCachelessProjection(String name) {
        String[] authorityAndCode = ProjectionFactory.parseAuthorityAndCode(name);
        return ProjectionFactory.getCachelessProjection(authorityAndCode[0], authorityAndCode[1]);
    }

    public static Projection getProjection(String authority, long code) {
        return ProjectionFactory.getProjection(authority, String.valueOf(code));
    }

    public static Projection getCachelessProjection(String authority, long code) {
        return ProjectionFactory.getCachelessProjection(authority, String.valueOf(code));
    }

    public static Projection getProjection(String authority, String code) {
        return ProjectionFactory.getProjection(authority, code, null, null);
    }

    public static Projection getCachelessProjection(String authority, String code) {
        return ProjectionFactory.getCachelessProjection(authority, code, null, null);
    }

    public static Projection getProjection(String authority, long code, String paramStr) {
        return ProjectionFactory.getProjection(authority, String.valueOf(code), paramStr);
    }

    public static Projection getCachelessProjection(String authority, long code, String paramStr) {
        return ProjectionFactory.getCachelessProjection(authority, String.valueOf(code), paramStr);
    }

    public static Projection getProjection(String authority, String code, String paramStr) {
        return ProjectionFactory.getProjection(authority, code, ProjectionFactory.buildParameters(paramStr));
    }

    public static Projection getCachelessProjection(String authority, String code, String paramStr) {
        return ProjectionFactory.getCachelessProjection(authority, code, ProjectionFactory.buildParameters(paramStr));
    }

    public static Projection getProjection(String authority, long code, String[] params) {
        return ProjectionFactory.getProjection(authority, String.valueOf(code), params);
    }

    public static Projection getCachelessProjection(String authority, long code, String[] params) {
        return ProjectionFactory.getCachelessProjection(authority, String.valueOf(code), params);
    }

    public static Projection getProjection(String authority, String code, String[] params) {
        return ProjectionFactory.getProjection(authority, code, params, null);
    }

    public static Projection getCachelessProjection(String authority, String code, String[] params) {
        return ProjectionFactory.getCachelessProjection(authority, code, params, null);
    }

    public static Projection getProjectionByDefinition(String authority, long code, String definition) {
        return ProjectionFactory.getProjectionByDefinition(authority, String.valueOf(code), definition);
    }

    public static Projection getCachelessProjectionByDefinition(String authority, long code, String definition) {
        return ProjectionFactory.getCachelessProjectionByDefinition(authority, String.valueOf(code), definition);
    }

    public static Projection getProjectionByDefinition(String authority, String code, String definition) {
        return ProjectionFactory.getProjection(authority, code, null, definition);
    }

    public static Projection getCachelessProjectionByDefinition(String authority, String code, String definition) {
        return ProjectionFactory.getCachelessProjection(authority, code, null, definition);
    }

    public static Projection getProjection(String authority, long code, String[] params, String definition) {
        return ProjectionFactory.getProjection(authority, String.valueOf(code), params, definition);
    }

    public static Projection getCachelessProjection(String authority, long code, String[] params, String definition) {
        return ProjectionFactory.getCachelessProjection(authority, String.valueOf(code), params, definition);
    }

    public static Projection getProjection(String authority, String code, String[] params, String definition) {
        return ProjectionFactory.getProjection(order, authority, code, params, definition);
    }

    public static Projection getCachelessProjection(String authority, String code, String[] params, String definition) {
        return ProjectionFactory.getProjection(ProjectionFactory.getCachelessOrder(), authority, code, params, definition);
    }

    public static Projection getProjection(Set<ProjectionFactoryType> types, String authority, String code, String[] params, String definition) {
        Projection projection = null;
        for (ProjectionFactoryType type : types) {
            projection = ProjectionFactory.getProjection(type, authority, code, params, definition);
            if (projection != null) {
                switch (type) {
                    case CACHE: {
                        if (definition == null || definition.isEmpty() || definition.equals(projection.getDefinition())) break;
                        projection = null;
                        break;
                    }
                }
            }
            if (projection == null) continue;
            break;
        }
        if (projection == null) {
            throw new ProjectionException("Failed to create projection for authority: " + authority + ", code: " + code + ", definition: " + definition + ", params: " + Arrays.toString(params));
        }
        return projection;
    }

    public static Projection getProjection(ProjectionFactoryType type, String authority, String code, String[] params, String definition) {
        Projection projection = null;
        authority = authority.toUpperCase();
        switch (type) {
            case CACHE: {
                projection = ProjectionFactory.fromCache(authority, code);
                break;
            }
            case DEFINITION: {
                projection = ProjectionFactory.fromDefinition(authority, code, definition);
                break;
            }
            case NAME: {
                projection = ProjectionFactory.fromName(authority, code, definition);
                break;
            }
            case PARAMETERS: {
                projection = ProjectionFactory.fromParams(authority, code, params, definition);
                break;
            }
            case PROPERTIES: {
                projection = ProjectionFactory.fromProperties(authority, code, definition);
                break;
            }
            default: {
                throw new ProjectionException("Unsupported projection factory type: " + (Object)((Object)type));
            }
        }
        return projection;
    }

    public static Projection getProjectionByDefinition(String definition) {
        return ProjectionFactory.getProjectionByDefinition(false, definition);
    }

    public static Projection getCachelessProjectionByDefinition(String definition) {
        return ProjectionFactory.getProjectionByDefinition(true, definition);
    }

    private static Projection getProjectionByDefinition(boolean cacheless, String definition) {
        Projection projection = null;
        if (definition != null && !definition.isEmpty()) {
            CRS definitionCRS = null;
            try {
                definitionCRS = CRSReader.read((String)definition);
            }
            catch (IOException e) {
                throw new ProjectionException("Failed to parse definition: " + definition, e);
            }
            if (definitionCRS != null) {
                CoordinateReferenceSystem crs;
                String authority = null;
                String code = null;
                if (definitionCRS.hasIdentifiers()) {
                    Identifier identifier = definitionCRS.getIdentifier(0);
                    authority = identifier.getName();
                    code = identifier.getUniqueIdentifier();
                }
                boolean cacheProjection = true;
                if (authority != null && code != null) {
                    if (!cacheless && (projection = ProjectionFactory.fromCache(authority, code)) != null && !definition.equals(projection.getDefinition())) {
                        projection = null;
                    }
                } else {
                    cacheProjection = false;
                    if (authority == null) {
                        authority = "";
                    }
                    if (code == null) {
                        code = "";
                    }
                }
                if (projection == null && (crs = CRSParser.convert(definitionCRS)) != null) {
                    projection = new Projection(authority, code, crs, definition, definitionCRS);
                    if (cacheProjection) {
                        projections.addProjection(projection);
                    }
                }
            }
        }
        if (projection == null) {
            throw new ProjectionException("Failed to create projection for definition: " + definition);
        }
        return projection;
    }

    public static Projections getProjections() {
        return projections;
    }

    public static AuthorityProjections getProjections(String authority) {
        return projections.getProjections(authority);
    }

    public static String[] parseAuthorityAndCode(String name) {
        String authority = null;
        String code = null;
        String[] projectionParts = name.split(":");
        switch (projectionParts.length) {
            case 1: {
                authority = "EPSG";
                code = projectionParts[0];
                break;
            }
            case 2: {
                authority = projectionParts[0];
                code = projectionParts[1];
                break;
            }
            default: {
                throw new ProjectionException("Invalid projection name '" + name + "', expected 'authority:code' or 'epsg_code'");
            }
        }
        return new String[]{authority, code};
    }

    public static String[] buildParameters(String paramStr) {
        String[] params = null;
        if (paramStr != null && !paramStr.isEmpty()) {
            params = paramStr.split("\\s+");
        }
        return params;
    }

    public static void clear() {
        projections.clear();
    }

    public static void clear(String authority) {
        projections.clear(authority);
    }

    public static void clear(String authority, long code) {
        projections.remove(authority, code);
    }

    public static void clear(String authority, String code) {
        projections.remove(authority, code);
    }

    private static Projection fromCache(String authority, String code) {
        return projections.getProjection(authority, code);
    }

    private static Projection fromDefinition(String authority, String code, String definition) {
        Projection projection = null;
        if (definition != null && !definition.isEmpty()) {
            try {
                CoordinateReferenceSystem crs = null;
                CRS definitionCRS = CRSReader.read((String)definition);
                if (definitionCRS != null) {
                    crs = CRSParser.convert(definitionCRS);
                }
                if (crs != null) {
                    projection = new Projection(authority, code, crs, definition, definitionCRS);
                    projections.addProjection(projection);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create projection for authority: " + authority + ", code: " + code + ", definition: " + definition, e);
            }
        }
        return projection;
    }

    private static Projection fromParams(String authority, String code, String[] params, String definition) {
        Projection projection = null;
        if (params != null && params.length > 0) {
            try {
                CoordinateReferenceSystem crs = CRSParser.getCRSFactory().createFromParameters(ProjectionFactory.coordinateName(authority, code), params);
                projection = new Projection(authority, code, crs, definition);
                projections.addProjection(projection);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create projection for authority: " + authority + ", code: " + code + ", parameters: " + Arrays.toString(params), e);
            }
        }
        return projection;
    }

    private static Projection fromProperties(String authority, String code, String definition) {
        Projection projection = null;
        String parameters = ProjectionRetriever.getProjection(authority, code);
        if (parameters != null && !parameters.isEmpty()) {
            try {
                CoordinateReferenceSystem crs = CRSParser.getCRSFactory().createFromParameters(ProjectionFactory.coordinateName(authority, code), parameters);
                projection = new Projection(authority, code, crs, definition);
                projections.addProjection(projection);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create projection for authority: " + authority + ", code: " + code + ", parameters: " + parameters, e);
            }
        }
        return projection;
    }

    private static Projection fromName(String authority, String code, String definition) {
        Projection projection = null;
        String name = ProjectionFactory.coordinateName(authority, code);
        try {
            CoordinateReferenceSystem crs = CRSParser.getCRSFactory().createFromName(name);
            projection = new Projection(authority, code, crs, definition);
            projections.addProjection(projection);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create projection from name: " + name, e);
        }
        return projection;
    }

    private static String coordinateName(String authority, String code) {
        return authority.toUpperCase() + ":" + code;
    }

    static {
        ProjectionFactory.resetOrder();
    }
}

