/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Curve;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.Point;
import mil.nga.sf.util.GeometryUtils;
import mil.nga.sf.util.sweep.ShamosHoey;

public class CompoundCurve
extends Curve {
    private List<LineString> lineStrings = new ArrayList<LineString>();

    public CompoundCurve() {
        this(false, false);
    }

    public CompoundCurve(boolean hasZ, boolean hasM) {
        super(GeometryType.COMPOUNDCURVE, hasZ, hasM);
    }

    public CompoundCurve(List<LineString> lineStrings) {
        this(GeometryUtils.hasZ(lineStrings), GeometryUtils.hasM(lineStrings));
        this.setLineStrings(lineStrings);
    }

    public CompoundCurve(LineString lineString) {
        this(lineString.hasZ(), lineString.hasM());
        this.addLineString(lineString);
    }

    public CompoundCurve(CompoundCurve compoundCurve) {
        this(compoundCurve.hasZ(), compoundCurve.hasM());
        for (LineString lineString : compoundCurve.getLineStrings()) {
            this.addLineString((LineString)lineString.copy());
        }
    }

    public List<LineString> getLineStrings() {
        return this.lineStrings;
    }

    public void setLineStrings(List<LineString> lineStrings) {
        this.lineStrings = lineStrings;
    }

    public void addLineString(LineString lineString) {
        this.lineStrings.add(lineString);
    }

    public void addLineStrings(List<LineString> lineStrings) {
        this.lineStrings.addAll(lineStrings);
    }

    public int numLineStrings() {
        return this.lineStrings.size();
    }

    public LineString getLineString(int n) {
        return this.lineStrings.get(n);
    }

    @Override
    public Point startPoint() {
        Point startPoint = null;
        if (!this.isEmpty()) {
            for (LineString lineString : this.lineStrings) {
                if (lineString.isEmpty()) continue;
                startPoint = lineString.startPoint();
                break;
            }
        }
        return startPoint;
    }

    @Override
    public Point endPoint() {
        Point endPoint = null;
        if (!this.isEmpty()) {
            for (int i = this.lineStrings.size() - 1; i >= 0; --i) {
                LineString lineString = this.lineStrings.get(i);
                if (lineString.isEmpty()) continue;
                endPoint = lineString.endPoint();
                break;
            }
        }
        return endPoint;
    }

    @Override
    public boolean isSimple() {
        return ShamosHoey.simplePolygon(this.lineStrings);
    }

    @Override
    public Geometry copy() {
        return new CompoundCurve(this);
    }

    @Override
    public boolean isEmpty() {
        return this.lineStrings.isEmpty();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.lineStrings == null ? 0 : this.lineStrings.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundCurve other = (CompoundCurve)obj;
        return !(this.lineStrings == null ? other.lineStrings != null : !this.lineStrings.equals(other.lineStrings));
    }
}

