/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Curve;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryType;
import mil.nga.sf.Surface;
import mil.nga.sf.util.GeometryUtils;

public class CurvePolygon<T extends Curve>
extends Surface {
    private List<T> rings = new ArrayList<T>();

    public CurvePolygon() {
        this(false, false);
    }

    public CurvePolygon(boolean hasZ, boolean hasM) {
        super(GeometryType.CURVEPOLYGON, hasZ, hasM);
    }

    public CurvePolygon(List<T> rings) {
        this(GeometryUtils.hasZ(rings), GeometryUtils.hasM(rings));
        this.setRings(rings);
    }

    public CurvePolygon(T ring) {
        this(((Geometry)ring).hasZ(), ((Geometry)ring).hasM());
        this.addRing(ring);
    }

    public CurvePolygon(CurvePolygon<T> curvePolygon) {
        this(curvePolygon.hasZ(), curvePolygon.hasM());
        for (Curve ring : curvePolygon.getRings()) {
            Curve ringCopy = (Curve)ring.copy();
            this.addRing(ringCopy);
        }
    }

    protected CurvePolygon(GeometryType type, boolean hasZ, boolean hasM) {
        super(type, hasZ, hasM);
    }

    public List<T> getRings() {
        return this.rings;
    }

    public void setRings(List<T> rings) {
        this.rings = rings;
    }

    public void addRing(T ring) {
        this.rings.add(ring);
    }

    public void addRings(List<T> rings) {
        this.rings.addAll(rings);
    }

    public int numRings() {
        return this.rings.size();
    }

    public T getRing(int n) {
        return (T)((Curve)this.rings.get(n));
    }

    public T getExteriorRing() {
        return (T)((Curve)this.rings.get(0));
    }

    public int numInteriorRings() {
        return this.rings.size() - 1;
    }

    public T getInteriorRing(int n) {
        return (T)((Curve)this.rings.get(n + 1));
    }

    @Override
    public Geometry copy() {
        return new CurvePolygon<T>(this);
    }

    @Override
    public boolean isEmpty() {
        return this.rings.isEmpty();
    }

    @Override
    public boolean isSimple() {
        throw new UnsupportedOperationException("Is Simple not implemented for " + this.getClass().getSimpleName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.rings == null ? 0 : this.rings.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CurvePolygon other = (CurvePolygon)obj;
        return !(this.rings == null ? other.rings != null : !this.rings.equals(other.rings));
    }
}

