/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryType;
import mil.nga.sf.MultiSurface;
import mil.nga.sf.Polygon;
import mil.nga.sf.util.GeometryUtils;

public class MultiPolygon
extends MultiSurface<Polygon> {
    public MultiPolygon() {
        this(false, false);
    }

    public MultiPolygon(boolean hasZ, boolean hasM) {
        super(GeometryType.MULTIPOLYGON, hasZ, hasM);
    }

    public MultiPolygon(List<Polygon> polygons) {
        this(GeometryUtils.hasZ(polygons), GeometryUtils.hasM(polygons));
        this.setPolygons(polygons);
    }

    public MultiPolygon(Polygon polygon) {
        this(polygon.hasZ(), polygon.hasM());
        this.addPolygon(polygon);
    }

    public MultiPolygon(MultiPolygon multiPolygon) {
        this(multiPolygon.hasZ(), multiPolygon.hasM());
        for (Polygon polygon : multiPolygon.getPolygons()) {
            this.addPolygon((Polygon)polygon.copy());
        }
    }

    public List<Polygon> getPolygons() {
        return this.getSurfaces();
    }

    public void setPolygons(List<Polygon> polygons) {
        this.setSurfaces(polygons);
    }

    public void addPolygon(Polygon polygon) {
        this.addSurface(polygon);
    }

    public void addPolygons(List<Polygon> polygons) {
        this.addSurfaces(polygons);
    }

    public int numPolygons() {
        return this.numSurfaces();
    }

    public Polygon getPolygon(int n) {
        return (Polygon)this.getSurface(n);
    }

    @Override
    public Geometry copy() {
        return new MultiPolygon(this);
    }
}

