/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import mil.nga.sf.util.SFException;

public class ByteReader {
    private static final String CHAR_SET = "UTF-8";
    private int nextByte = 0;
    private final byte[] bytes;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public ByteReader(byte[] bytes) {
        this.bytes = bytes;
    }

    public int getNextByte() {
        return this.nextByte;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public String readString(int num) throws UnsupportedEncodingException {
        this.verifyRemainingBytes(num);
        String value = new String(this.bytes, this.nextByte, num, CHAR_SET);
        this.nextByte += num;
        return value;
    }

    public byte readByte() {
        this.verifyRemainingBytes(1);
        byte value = this.bytes[this.nextByte];
        ++this.nextByte;
        return value;
    }

    public int readInt() {
        this.verifyRemainingBytes(4);
        int value = ByteBuffer.wrap(this.bytes, this.nextByte, 4).order(this.byteOrder).getInt();
        this.nextByte += 4;
        return value;
    }

    public long readUnsignedInt() {
        int intValue = this.readInt();
        long value = (long)intValue & 0xFFFFFFFFL;
        return value;
    }

    public double readDouble() {
        this.verifyRemainingBytes(8);
        double value = ByteBuffer.wrap(this.bytes, this.nextByte, 8).order(this.byteOrder).getDouble();
        this.nextByte += 8;
        return value;
    }

    private void verifyRemainingBytes(int bytesToRead) {
        if (this.nextByte + bytesToRead > this.bytes.length) {
            throw new SFException("No more remaining bytes to read. Total Bytes: " + this.bytes.length + ", Bytes already read: " + this.nextByte + ", Attempted to read: " + bytesToRead);
        }
    }
}

