/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteWriter {
    private final ByteArrayOutputStream os = new ByteArrayOutputStream();
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public void close() {
        try {
            this.os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public byte[] getBytes() {
        return this.os.toByteArray();
    }

    public int size() {
        return this.os.size();
    }

    public void writeString(String value) throws IOException {
        byte[] valueBytes = value.getBytes();
        this.os.write(valueBytes);
    }

    public void writeByte(byte value) {
        this.os.write(value);
    }

    public void writeInt(int value) throws IOException {
        byte[] valueBytes = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(this.byteOrder).putInt(value);
        byteBuffer.flip();
        byteBuffer.get(valueBytes);
        this.os.write(valueBytes);
    }

    public void writeDouble(double value) throws IOException {
        byte[] valueBytes = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(this.byteOrder).putDouble(value);
        byteBuffer.flip();
        byteBuffer.get(valueBytes);
        this.os.write(valueBytes);
    }
}

