/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.sf.util.SFException;

public class TextReader {
    private static final Logger logger = Logger.getLogger(TextReader.class.getName());
    private final Reader reader;
    private String nextToken;
    private Integer nextCharacterNum;

    public TextReader(String text) {
        this(new StringReader(text));
    }

    public TextReader(Reader reader) {
        this.reader = reader;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to close text reader", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String readToken() throws IOException {
        int characterNum;
        String token = null;
        if (this.nextToken != null) {
            token = this.nextToken;
            this.nextToken = null;
            return token;
        }
        StringBuilder builder = null;
        if (this.nextCharacterNum != null) {
            characterNum = this.nextCharacterNum;
            this.nextCharacterNum = null;
        } else {
            characterNum = this.reader.read();
        }
        while (characterNum != -1) {
            block8: {
                char character = (char)characterNum;
                if (builder != null) {
                    if (TextReader.isTokenCharacter(character)) {
                        builder.append(character);
                        break block8;
                    } else {
                        if (Character.isWhitespace(character)) break;
                        this.nextCharacterNum = characterNum;
                        break;
                    }
                }
                if (!Character.isWhitespace(character)) {
                    builder = new StringBuilder();
                    builder.append(character);
                    if (!TextReader.isTokenCharacter(character)) break;
                }
            }
            characterNum = this.reader.read();
        }
        if (builder == null) return token;
        return builder.toString();
    }

    public String peekToken() throws IOException {
        if (this.nextToken == null) {
            this.nextToken = this.readToken();
        }
        return this.nextToken;
    }

    public double readDouble() throws IOException {
        String token = this.readToken();
        if (token == null) {
            throw new SFException("Failed to read expected double value");
        }
        return Double.parseDouble(token);
    }

    private static boolean isTokenCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '+';
    }
}

