/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.util.centroid;

import mil.nga.sf.CompoundCurve;
import mil.nga.sf.Curve;
import mil.nga.sf.CurvePolygon;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.PolyhedralSurface;
import mil.nga.sf.util.GeometryUtils;
import mil.nga.sf.util.SFException;

public class DegreesCentroid {
    public static final double RADIANS_TO_DEGREES = 57.29577951308232;
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    private final Geometry geometry;
    private int points = 0;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;

    public static Point getCentroid(Geometry geometry) {
        return new DegreesCentroid(geometry).getCentroid();
    }

    public DegreesCentroid(Geometry geometry) {
        this.geometry = geometry;
    }

    public Point getCentroid() {
        Point centroid = null;
        if (this.geometry.getGeometryType() == GeometryType.POINT) {
            centroid = (Point)this.geometry;
        } else {
            this.calculate(this.geometry);
            this.x /= (double)this.points;
            this.y /= (double)this.points;
            this.z /= (double)this.points;
            double centroidLongitude = Math.atan2(this.y, this.x);
            double centroidLatitude = Math.atan2(this.z, Math.sqrt(this.x * this.x + this.y * this.y));
            centroid = new Point(centroidLongitude * 57.29577951308232, centroidLatitude * 57.29577951308232);
        }
        return centroid;
    }

    private void calculate(Geometry geometry) {
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case GEOMETRY: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POINT: {
                this.calculatePoint((Point)geometry);
                break;
            }
            case LINESTRING: 
            case CIRCULARSTRING: {
                this.calculateLineString((LineString)geometry);
                break;
            }
            case POLYGON: 
            case TRIANGLE: {
                this.calculatePolygon((Polygon)geometry);
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTIPOINT: 
            case MULTICURVE: 
            case MULTILINESTRING: 
            case MULTISURFACE: 
            case MULTIPOLYGON: {
                this.calculateGeometryCollection((GeometryCollection)geometry);
                break;
            }
            case COMPOUNDCURVE: {
                this.calculateCompoundCurve((CompoundCurve)geometry);
                break;
            }
            case CURVEPOLYGON: {
                this.calculateCurvePolygon((CurvePolygon)geometry);
                break;
            }
            case CURVE: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case SURFACE: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POLYHEDRALSURFACE: 
            case TIN: {
                this.calculatePolyhedralSurface((PolyhedralSurface)geometry);
                break;
            }
            default: {
                throw new SFException("Geometry Type not supported: " + geometryType);
            }
        }
    }

    private void calculatePoint(Point point) {
        double latitude = point.getY() * (Math.PI / 180);
        double longitude = point.getX() * (Math.PI / 180);
        double cosLatitude = Math.cos(latitude);
        this.x += cosLatitude * Math.cos(longitude);
        this.y += cosLatitude * Math.sin(longitude);
        this.z += Math.sin(latitude);
        ++this.points;
    }

    private void calculateLineString(LineString lineString) {
        for (Point point : lineString.getPoints()) {
            this.calculatePoint(point);
        }
    }

    private void calculatePolygon(Polygon polygon) {
        if (polygon.numRings() > 0) {
            LineString exteriorRing = (LineString)polygon.getExteriorRing();
            int numPoints = exteriorRing.numPoints();
            if (GeometryUtils.closedPolygon(exteriorRing)) {
                --numPoints;
            }
            for (int i = 0; i < numPoints; ++i) {
                this.calculatePoint(exteriorRing.getPoint(i));
            }
        }
    }

    private void calculateGeometryCollection(GeometryCollection<?> geometryCollection) {
        for (Geometry geometry : geometryCollection.getGeometries()) {
            this.calculate(geometry);
        }
    }

    private void calculateCompoundCurve(CompoundCurve compoundCurve) {
        for (LineString lineString : compoundCurve.getLineStrings()) {
            this.calculateLineString(lineString);
        }
    }

    private void calculateCurvePolygon(CurvePolygon<?> curvePolygon) {
        for (Curve ring : curvePolygon.getRings()) {
            this.calculate(ring);
        }
    }

    private void calculatePolyhedralSurface(PolyhedralSurface polyhedralSurface) {
        for (Polygon polygon : polyhedralSurface.getPolygons()) {
            this.calculatePolygon(polygon);
        }
    }
}

