/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Map;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryType;
import mil.nga.sf.geojson.FeatureConverter;
import mil.nga.sf.geojson.GeoJsonObject;
import mil.nga.sf.geojson.Point;
import mil.nga.sf.geojson.SimpleFeature;

@JsonPropertyOrder(value={"type", "id", "geometry", "properties"})
public class Feature
extends GeoJsonObject {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private SimpleFeature feature = new SimpleFeature();
    private String id;

    public Feature() {
    }

    public Feature(mil.nga.sf.geojson.Geometry geometry) {
        this.setGeometry(geometry);
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public mil.nga.sf.geojson.Geometry getGeometry() {
        return FeatureConverter.toGeometry(this.feature.getGeometry());
    }

    public void setGeometry(mil.nga.sf.geojson.Geometry geometry) {
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            this.feature.setGeometry(point.getGeometry());
        } else {
            this.feature.setGeometry(geometry == null ? null : geometry.getGeometry());
        }
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, Object> getProperties() {
        return this.feature.getProperties();
    }

    public void setProperties(Map<String, Object> properties) {
        this.feature.setProperties(properties);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SimpleFeature getFeature() {
        return this.feature;
    }

    @JsonIgnore
    public Geometry getSimpleGeometry() {
        return this.feature.getGeometry();
    }

    @JsonIgnore
    public GeometryType getGeometryType() {
        Geometry simpleGeometry;
        GeometryType geometryType = null;
        mil.nga.sf.geojson.Geometry geometry = this.getGeometry();
        if (geometry != null && (simpleGeometry = geometry.getGeometry()) != null) {
            geometryType = simpleGeometry.getGeometryType();
        }
        return geometryType;
    }

    @Override
    public String getType() {
        return "Feature";
    }
}

