/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mil.nga.sf.Point;
import mil.nga.sf.geojson.jackson.CoordinatesDeserializer;
import mil.nga.sf.geojson.jackson.CoordinatesSerializer;

@JsonDeserialize(using=CoordinatesDeserializer.class)
@JsonSerialize(using=CoordinatesSerializer.class)
public class Position
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double[] coordinates;
    private final List<Double> additionalElements;

    public Position(Point point) {
        this(point.getX(), point.getY(), point.getZ(), point.getM());
    }

    public Position(Double longitude, Double latitude) {
        this(longitude, latitude, null, new Double[0]);
    }

    public Position(Double longitude, Double latitude, Double altitude, Double ... additionalElements) {
        if (longitude == null || latitude == null) {
            this.coordinates = new double[0];
            this.additionalElements = new ArrayList<Double>();
        } else if (altitude == null) {
            this.coordinates = new double[]{longitude, latitude};
            this.additionalElements = new ArrayList<Double>();
        } else {
            this.coordinates = new double[]{longitude, latitude, altitude};
            if (Position.additionalElementsPresent(additionalElements)) {
                this.additionalElements = Arrays.asList(additionalElements);
                for (Double element : this.additionalElements) {
                    if (Double.isNaN(element)) {
                        throw new IllegalArgumentException("No additional elements may be NaN.");
                    }
                    if (!Double.isInfinite(element)) continue;
                    throw new IllegalArgumentException("No additional elements may be infinite.");
                }
            } else {
                this.additionalElements = new ArrayList<Double>();
            }
        }
        this.checkAltitudeAndAdditionalElements();
    }

    public boolean hasAdditionalElements() {
        return !this.additionalElements.isEmpty();
    }

    public List<Double> getAdditionalElements() {
        return this.additionalElements;
    }

    private void checkAltitudeAndAdditionalElements() {
        if (this.getZ() == null && this.hasAdditionalElements()) {
            throw new IllegalArgumentException("Additional Elements are only valid if Altitude is also provided.");
        }
    }

    private static boolean additionalElementsPresent(Double[] additionalElements) {
        return additionalElements.length > 0 && additionalElements[0] != null;
    }

    public Double getX() {
        return this.coordinates.length > 0 ? Double.valueOf(this.coordinates[0]) : null;
    }

    public Double getY() {
        return this.coordinates.length > 1 ? Double.valueOf(this.coordinates[1]) : null;
    }

    public Double getZ() {
        return this.hasZ() ? Double.valueOf(this.coordinates[2]) : null;
    }

    public Double getM() {
        return this.hasM() ? this.additionalElements.get(0) : null;
    }

    public boolean hasZ() {
        return this.coordinates.length > 2;
    }

    public boolean hasM() {
        return this.additionalElements.size() > 0;
    }

    public Point toSimplePoint() {
        Point point = null;
        Double x = this.getX();
        Double y = this.getY();
        if (x != null && y != null) {
            point = new Point(x.doubleValue(), y.doubleValue(), this.getZ(), this.getM());
        }
        return point;
    }
}

