/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.LineString;
import mil.nga.sf.LinearRing;
import mil.nga.sf.Point;
import mil.nga.sf.geojson.Position;
import mil.nga.sf.util.GeometryUtils;

public class Polygon
extends mil.nga.sf.geojson.Geometry {
    private static final long serialVersionUID = 1L;
    private mil.nga.sf.Polygon polygon;

    public Polygon() {
    }

    public Polygon(List<List<Position>> positions) {
        this.setCoordinates(positions);
    }

    public Polygon(mil.nga.sf.Polygon polygon) {
        this.polygon = polygon;
    }

    public List<List<Position>> getCoordinates() {
        ArrayList<List<Position>> result = new ArrayList<List<Position>>();
        for (LineString ring : this.polygon.getRings()) {
            ArrayList<Position> positions = new ArrayList<Position>();
            for (Point pos : ring.getPoints()) {
                positions.add(new Position(pos));
            }
            result.add(positions);
        }
        return result;
    }

    private void setCoordinates(List<List<Position>> positionList) {
        ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
        for (List<Position> ringPositions : positionList) {
            ArrayList<Point> points = new ArrayList<Point>();
            for (Position position : ringPositions) {
                points.add(position.toSimplePoint());
            }
            LinearRing ring = new LinearRing(GeometryUtils.hasZ(points), GeometryUtils.hasM(points));
            ring.setPoints(points);
            rings.add(ring);
        }
        if (this.polygon == null) {
            this.polygon = new mil.nga.sf.Polygon(rings);
        } else {
            this.polygon.setRings(rings);
        }
    }

    @Override
    public Geometry getGeometry() {
        return this.polygon;
    }

    @Override
    public String getType() {
        return "Polygon";
    }
}

