/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.LineString;
import mil.nga.sf.LinearRing;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.geojson.Position;
import mil.nga.sf.util.GeometryUtils;

public class MultiPolygon
extends mil.nga.sf.geojson.Geometry {
    private static final long serialVersionUID = 1L;
    private mil.nga.sf.MultiPolygon multiPolygon;

    public MultiPolygon() {
    }

    public MultiPolygon(List<List<List<Position>>> positions) {
        this.setCoordinates(positions);
    }

    public MultiPolygon(mil.nga.sf.MultiPolygon multiPolygon) {
        this.multiPolygon = multiPolygon;
    }

    public List<List<List<Position>>> getCoordinates() {
        ArrayList<List<List<Position>>> result = new ArrayList<List<List<Position>>>();
        for (Polygon polygon : this.multiPolygon.getGeometries()) {
            ArrayList polygonPositions = new ArrayList();
            for (LineString ring : polygon.getRings()) {
                ArrayList<Position> positions = new ArrayList<Position>();
                for (Point pos : ring.getPoints()) {
                    positions.add(new Position(pos));
                }
                polygonPositions.add(positions);
            }
            result.add(polygonPositions);
        }
        return result;
    }

    private void setCoordinates(List<List<List<Position>>> positionList) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (List<List<Position>> polygonPositions : positionList) {
            ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
            for (List<Position> ringPositions : polygonPositions) {
                ArrayList<Point> points = new ArrayList<Point>();
                for (Position position : ringPositions) {
                    points.add(position.toSimplePoint());
                }
                LinearRing ring = new LinearRing(GeometryUtils.hasZ(points), GeometryUtils.hasM(points));
                ring.setPoints(points);
                rings.add(ring);
            }
            Polygon polygon = new Polygon(rings);
            polygons.add(polygon);
        }
        if (this.multiPolygon == null) {
            this.multiPolygon = new mil.nga.sf.MultiPolygon(polygons);
        } else {
            this.multiPolygon.setGeometries(polygons);
        }
    }

    @Override
    public Geometry getGeometry() {
        return this.multiPolygon;
    }

    @Override
    public String getType() {
        return "MultiPolygon";
    }
}

