/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.geojson.GeometryType;
import mil.nga.sf.geojson.Point;
import mil.nga.sf.geojson.Position;

public class LineString
extends mil.nga.sf.geojson.Geometry {
    private static final long serialVersionUID = 2L;
    private List<Point> points = null;

    public static LineString fromCoordinates(List<Position> coordinates) {
        LineString lineString = new LineString();
        lineString.setCoordinates(coordinates);
        return lineString;
    }

    public LineString() {
    }

    public LineString(List<Point> points) {
        this.points = points;
    }

    public LineString(mil.nga.sf.LineString lineString) {
        this.setLineString(lineString);
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.LINESTRING;
    }

    @Override
    public Geometry getGeometry() {
        return this.getLineString();
    }

    public List<Position> getCoordinates() {
        ArrayList<Position> coordinates = new ArrayList<Position>();
        for (Point point : this.points) {
            coordinates.add(point.getCoordinates());
        }
        return coordinates;
    }

    public void setCoordinates(List<Position> coordinates) {
        this.points = new ArrayList<Point>();
        for (Position position : coordinates) {
            this.points.add(Point.fromCoordinates(position));
        }
    }

    @JsonIgnore
    public mil.nga.sf.LineString getLineString() {
        ArrayList<mil.nga.sf.Point> simplePoints = new ArrayList<mil.nga.sf.Point>();
        for (Point point : this.points) {
            simplePoints.add(point.getPoint());
        }
        return new mil.nga.sf.LineString(simplePoints);
    }

    public void setLineString(mil.nga.sf.LineString lineString) {
        this.points = new ArrayList<Point>();
        for (mil.nga.sf.Point point : lineString.getPoints()) {
            this.points.add(new Point(point));
        }
    }
}

