/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.Polygon;
import mil.nga.sf.geojson.GeometryType;
import mil.nga.sf.geojson.Position;

public class MultiPolygon
extends mil.nga.sf.geojson.Geometry {
    private static final long serialVersionUID = 2L;
    private List<mil.nga.sf.geojson.Polygon> polygons = null;

    public static MultiPolygon fromCoordinates(List<List<List<Position>>> coordinates) {
        MultiPolygon multiPolygon = new MultiPolygon();
        multiPolygon.setCoordinates(coordinates);
        return multiPolygon;
    }

    public MultiPolygon() {
    }

    public MultiPolygon(List<mil.nga.sf.geojson.Polygon> polygons) {
        this.polygons = polygons;
    }

    public MultiPolygon(mil.nga.sf.MultiPolygon multiPolygon) {
        this.setMultiPolygon(multiPolygon);
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.MULTIPOLYGON;
    }

    @Override
    public Geometry getGeometry() {
        return this.getMultiPolygon();
    }

    public List<List<List<Position>>> getCoordinates() {
        ArrayList<List<List<Position>>> coordinates = new ArrayList<List<List<Position>>>();
        for (mil.nga.sf.geojson.Polygon polygon : this.polygons) {
            coordinates.add(polygon.getCoordinates());
        }
        return coordinates;
    }

    public void setCoordinates(List<List<List<Position>>> coordinates) {
        this.polygons = new ArrayList<mil.nga.sf.geojson.Polygon>();
        for (List<List<Position>> positions : coordinates) {
            this.polygons.add(mil.nga.sf.geojson.Polygon.fromCoordinates(positions));
        }
    }

    @JsonIgnore
    public List<mil.nga.sf.geojson.Polygon> getPolygons() {
        return this.polygons;
    }

    public void setPolygons(List<mil.nga.sf.geojson.Polygon> polygons) {
        this.polygons = polygons;
    }

    @JsonIgnore
    public mil.nga.sf.MultiPolygon getMultiPolygon() {
        ArrayList<Polygon> simplePolygons = new ArrayList<Polygon>();
        for (mil.nga.sf.geojson.Polygon polygon : this.polygons) {
            simplePolygons.add(polygon.getPolygon());
        }
        return new mil.nga.sf.MultiPolygon(simplePolygons);
    }

    public void setMultiPolygon(mil.nga.sf.MultiPolygon multiPolygon) {
        this.polygons = new ArrayList<mil.nga.sf.geojson.Polygon>();
        for (Polygon polygon : multiPolygon.getPolygons()) {
            this.polygons.add(new mil.nga.sf.geojson.Polygon(polygon));
        }
    }
}

