/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.proj;

import mil.nga.sf.proj.ProjectionFactory;
import mil.nga.sf.proj.ProjectionTransform;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.proj.LongLatProjection;
import org.osgeo.proj4j.units.Unit;
import org.osgeo.proj4j.units.Units;

public class Projection {
    private final String authority;
    private final String code;
    private final CoordinateReferenceSystem crs;
    private Unit unit;

    public Projection(String authority, long code, CoordinateReferenceSystem crs) {
        this(authority, String.valueOf(code), crs);
    }

    public Projection(String authority, String code, CoordinateReferenceSystem crs) {
        if (authority == null || code == null || crs == null) {
            throw new IllegalArgumentException("All projection arguments are required. authority: " + authority + ", code: " + code + ", crs: " + crs);
        }
        this.authority = authority;
        this.code = code;
        this.crs = crs;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getCode() {
        return this.code;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public ProjectionTransform getTransformation(long epsg) {
        return this.getTransformation("EPSG", epsg);
    }

    public ProjectionTransform getTransformation(String authority, long code) {
        Projection projectionTo = ProjectionFactory.getProjection(authority, code);
        return this.getTransformation(projectionTo);
    }

    public ProjectionTransform getTransformation(Projection projection) {
        return new ProjectionTransform(this, projection);
    }

    public double toMeters(double value) {
        return value / this.crs.getProjection().getFromMetres();
    }

    public Unit getUnit() {
        if (this.unit == null) {
            if (this.crs.getProjection() instanceof LongLatProjection) {
                this.unit = Units.DEGREES;
            } else {
                String unitParam = null;
                for (String param : this.crs.getParameters()) {
                    int index;
                    if (!param.startsWith("+units") || (index = param.indexOf(61)) == -1) continue;
                    unitParam = param.substring(index + 1);
                    break;
                }
                this.unit = unitParam != null ? Units.findUnits(unitParam) : Units.METRES;
            }
        }
        return this.unit;
    }

    public boolean equals(String authority, long code) {
        return this.equals(authority, String.valueOf(code));
    }

    public boolean equals(String authority, String code) {
        return this.authority.equals(authority) && this.code.equals(code);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.authority.hashCode();
        result = 31 * result + this.code.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Projection other = (Projection)obj;
        return this.equals(other.authority, other.code);
    }
}

