/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.wkb;

import java.nio.ByteOrder;
import mil.nga.sf.CircularString;
import mil.nga.sf.CompoundCurve;
import mil.nga.sf.Curve;
import mil.nga.sf.CurvePolygon;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.MultiLineString;
import mil.nga.sf.MultiPoint;
import mil.nga.sf.MultiPolygon;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.PolyhedralSurface;
import mil.nga.sf.TIN;
import mil.nga.sf.Triangle;
import mil.nga.sf.util.ByteReader;
import mil.nga.sf.util.SFException;
import mil.nga.sf.wkb.GeometryCodes;
import mil.nga.sf.wkb.GeometryTypeInfo;

public class GeometryReader {
    private static final long WKB25D = Long.decode("0x80000000");

    public static Geometry readGeometry(ByteReader reader) {
        Object geometry = GeometryReader.readGeometry(reader, null);
        return geometry;
    }

    public static <T extends Geometry> T readGeometry(ByteReader reader, Class<T> expectedType) {
        ByteOrder originalByteOrder = reader.getByteOrder();
        GeometryTypeInfo geometryTypeInfo = GeometryReader.readGeometryType(reader);
        GeometryType geometryType = geometryTypeInfo.getGeometryType();
        boolean hasZ = geometryTypeInfo.hasZ();
        boolean hasM = geometryTypeInfo.hasM();
        PolyhedralSurface geometry = null;
        switch (geometryType) {
            case GEOMETRY: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POINT: {
                geometry = GeometryReader.readPoint(reader, hasZ, hasM);
                break;
            }
            case LINESTRING: {
                geometry = GeometryReader.readLineString(reader, hasZ, hasM);
                break;
            }
            case POLYGON: {
                geometry = GeometryReader.readPolygon(reader, hasZ, hasM);
                break;
            }
            case MULTIPOINT: {
                geometry = GeometryReader.readMultiPoint(reader, hasZ, hasM);
                break;
            }
            case MULTILINESTRING: {
                geometry = GeometryReader.readMultiLineString(reader, hasZ, hasM);
                break;
            }
            case MULTIPOLYGON: {
                geometry = GeometryReader.readMultiPolygon(reader, hasZ, hasM);
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                geometry = GeometryReader.readGeometryCollection(reader, hasZ, hasM);
                break;
            }
            case CIRCULARSTRING: {
                geometry = GeometryReader.readCircularString(reader, hasZ, hasM);
                break;
            }
            case COMPOUNDCURVE: {
                geometry = GeometryReader.readCompoundCurve(reader, hasZ, hasM);
                break;
            }
            case CURVEPOLYGON: {
                geometry = GeometryReader.readCurvePolygon(reader, hasZ, hasM);
                break;
            }
            case CURVE: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case SURFACE: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POLYHEDRALSURFACE: {
                geometry = GeometryReader.readPolyhedralSurface(reader, hasZ, hasM);
                break;
            }
            case TIN: {
                geometry = GeometryReader.readTIN(reader, hasZ, hasM);
                break;
            }
            case TRIANGLE: {
                geometry = GeometryReader.readTriangle(reader, hasZ, hasM);
                break;
            }
            default: {
                throw new SFException("Geometry Type not supported: " + geometryType);
            }
        }
        if (expectedType != null && geometry != null && !expectedType.isAssignableFrom(geometry.getClass())) {
            throw new SFException("Unexpected Geometry Type. Expected: " + expectedType.getSimpleName() + ", Actual: " + geometry.getClass().getSimpleName());
        }
        reader.setByteOrder(originalByteOrder);
        PolyhedralSurface result = geometry;
        return (T)result;
    }

    public static GeometryTypeInfo readGeometryType(ByteReader reader) {
        byte byteOrderValue = reader.readByte();
        ByteOrder byteOrder = byteOrderValue == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        reader.setByteOrder(byteOrder);
        long unsignedGeometryTypeCode = reader.readUnsignedInt();
        boolean hasZ = false;
        if (unsignedGeometryTypeCode > WKB25D) {
            hasZ = true;
            unsignedGeometryTypeCode -= WKB25D;
        }
        int geometryTypeCode = (int)unsignedGeometryTypeCode;
        GeometryType geometryType = GeometryCodes.getGeometryType(geometryTypeCode);
        if (!hasZ) {
            hasZ = GeometryCodes.hasZ(geometryTypeCode);
        }
        boolean hasM = GeometryCodes.hasM(geometryTypeCode);
        GeometryTypeInfo geometryInfo = new GeometryTypeInfo(geometryTypeCode, geometryType, hasZ, hasM);
        return geometryInfo;
    }

    public static Point readPoint(ByteReader reader, boolean hasZ, boolean hasM) {
        double x = reader.readDouble();
        double y = reader.readDouble();
        Point point = new Point(hasZ, hasM, x, y);
        if (hasZ) {
            double z = reader.readDouble();
            point.setZ(Double.valueOf(z));
        }
        if (hasM) {
            double m = reader.readDouble();
            point.setM(Double.valueOf(m));
        }
        return point;
    }

    public static LineString readLineString(ByteReader reader, boolean hasZ, boolean hasM) {
        LineString lineString = new LineString(hasZ, hasM);
        int numPoints = reader.readInt();
        for (int i = 0; i < numPoints; ++i) {
            Point point = GeometryReader.readPoint(reader, hasZ, hasM);
            lineString.addPoint(point);
        }
        return lineString;
    }

    public static Polygon readPolygon(ByteReader reader, boolean hasZ, boolean hasM) {
        Polygon polygon = new Polygon(hasZ, hasM);
        int numRings = reader.readInt();
        for (int i = 0; i < numRings; ++i) {
            LineString ring = GeometryReader.readLineString(reader, hasZ, hasM);
            polygon.addRing((Curve)ring);
        }
        return polygon;
    }

    public static MultiPoint readMultiPoint(ByteReader reader, boolean hasZ, boolean hasM) {
        MultiPoint multiPoint = new MultiPoint(hasZ, hasM);
        int numPoints = reader.readInt();
        for (int i = 0; i < numPoints; ++i) {
            Point point = GeometryReader.readGeometry(reader, Point.class);
            multiPoint.addPoint(point);
        }
        return multiPoint;
    }

    public static MultiLineString readMultiLineString(ByteReader reader, boolean hasZ, boolean hasM) {
        MultiLineString multiLineString = new MultiLineString(hasZ, hasM);
        int numLineStrings = reader.readInt();
        for (int i = 0; i < numLineStrings; ++i) {
            LineString lineString = GeometryReader.readGeometry(reader, LineString.class);
            multiLineString.addLineString(lineString);
        }
        return multiLineString;
    }

    public static MultiPolygon readMultiPolygon(ByteReader reader, boolean hasZ, boolean hasM) {
        MultiPolygon multiPolygon = new MultiPolygon(hasZ, hasM);
        int numPolygons = reader.readInt();
        for (int i = 0; i < numPolygons; ++i) {
            Polygon polygon = GeometryReader.readGeometry(reader, Polygon.class);
            multiPolygon.addPolygon(polygon);
        }
        return multiPolygon;
    }

    public static GeometryCollection<Geometry> readGeometryCollection(ByteReader reader, boolean hasZ, boolean hasM) {
        GeometryCollection geometryCollection = new GeometryCollection(hasZ, hasM);
        int numGeometries = reader.readInt();
        for (int i = 0; i < numGeometries; ++i) {
            Geometry geometry = GeometryReader.readGeometry(reader, Geometry.class);
            geometryCollection.addGeometry(geometry);
        }
        return geometryCollection;
    }

    public static CircularString readCircularString(ByteReader reader, boolean hasZ, boolean hasM) {
        CircularString circularString = new CircularString(hasZ, hasM);
        int numPoints = reader.readInt();
        for (int i = 0; i < numPoints; ++i) {
            Point point = GeometryReader.readPoint(reader, hasZ, hasM);
            circularString.addPoint(point);
        }
        return circularString;
    }

    public static CompoundCurve readCompoundCurve(ByteReader reader, boolean hasZ, boolean hasM) {
        CompoundCurve compoundCurve = new CompoundCurve(hasZ, hasM);
        int numLineStrings = reader.readInt();
        for (int i = 0; i < numLineStrings; ++i) {
            LineString lineString = GeometryReader.readGeometry(reader, LineString.class);
            compoundCurve.addLineString(lineString);
        }
        return compoundCurve;
    }

    public static CurvePolygon<Curve> readCurvePolygon(ByteReader reader, boolean hasZ, boolean hasM) {
        CurvePolygon curvePolygon = new CurvePolygon(hasZ, hasM);
        int numRings = reader.readInt();
        for (int i = 0; i < numRings; ++i) {
            Curve ring = GeometryReader.readGeometry(reader, Curve.class);
            curvePolygon.addRing(ring);
        }
        return curvePolygon;
    }

    public static PolyhedralSurface readPolyhedralSurface(ByteReader reader, boolean hasZ, boolean hasM) {
        PolyhedralSurface polyhedralSurface = new PolyhedralSurface(hasZ, hasM);
        int numPolygons = reader.readInt();
        for (int i = 0; i < numPolygons; ++i) {
            Polygon polygon = GeometryReader.readGeometry(reader, Polygon.class);
            polyhedralSurface.addPolygon(polygon);
        }
        return polyhedralSurface;
    }

    public static TIN readTIN(ByteReader reader, boolean hasZ, boolean hasM) {
        TIN tin = new TIN(hasZ, hasM);
        int numPolygons = reader.readInt();
        for (int i = 0; i < numPolygons; ++i) {
            Polygon polygon = GeometryReader.readGeometry(reader, Polygon.class);
            tin.addPolygon(polygon);
        }
        return tin;
    }

    public static Triangle readTriangle(ByteReader reader, boolean hasZ, boolean hasM) {
        Triangle triangle = new Triangle(hasZ, hasM);
        int numRings = reader.readInt();
        for (int i = 0; i < numRings; ++i) {
            LineString ring = GeometryReader.readLineString(reader, hasZ, hasM);
            triangle.addRing((Curve)ring);
        }
        return triangle;
    }
}

