/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mil.nga.tiff.util.TiffException;

public class Rasters {
    private Number[][] sampleValues;
    private Number[] interleaveValues;
    private final int width;
    private final int height;
    private final int samplesPerPixel;
    private final List<Integer> bitsPerSample;

    public Rasters(int width, int height, int samplesPerPixel, List<Integer> bitsPerSample, Number[][] sampleValues) {
        this(width, height, samplesPerPixel, bitsPerSample, sampleValues, null);
    }

    public Rasters(int width, int height, int samplesPerPixel, List<Integer> bitsPerSample, Number[] interleaveValues) {
        this(width, height, samplesPerPixel, bitsPerSample, null, interleaveValues);
    }

    public Rasters(int width, int height, int samplesPerPixel, List<Integer> bitsPerSample, Number[][] sampleValues, Number[] interleaveValues) {
        this.width = width;
        this.height = height;
        this.samplesPerPixel = samplesPerPixel;
        this.bitsPerSample = bitsPerSample;
        this.sampleValues = sampleValues;
        this.interleaveValues = interleaveValues;
        this.validateValues();
        for (int bits : bitsPerSample) {
            if (bits % 8 == 0) continue;
            throw new TiffException("Sample bit-width of " + bits + " is not supported");
        }
    }

    private void validateValues() {
        if (this.sampleValues == null && this.interleaveValues == null) {
            throw new TiffException("Results must be sample and/or interleave based");
        }
    }

    public Rasters(int width, int height, int samplesPerPixel, List<Integer> bitsPerSample) {
        this(width, height, samplesPerPixel, bitsPerSample, new Number[samplesPerPixel][width * height]);
    }

    public Rasters(int width, int height, int samplesPerPixel, int bitsPerSample) {
        this(width, height, samplesPerPixel, new ArrayList<Integer>(Arrays.asList(bitsPerSample)));
    }

    public boolean hasSampleValues() {
        return this.sampleValues != null;
    }

    public boolean hasInterleaveValues() {
        return this.interleaveValues != null;
    }

    public void addToSample(int sampleIndex, int coordinate, Number value) {
        this.sampleValues[sampleIndex][coordinate] = value;
    }

    public void addToInterleave(int coordinate, Number value) {
        this.interleaveValues[coordinate] = value;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumPixels() {
        return this.width * this.height;
    }

    public int getSamplesPerPixel() {
        return this.samplesPerPixel;
    }

    public List<Integer> getBitsPerSample() {
        return this.bitsPerSample;
    }

    public Number[][] getSampleValues() {
        return this.sampleValues;
    }

    public void setSampleValues(Number[][] sampleValues) {
        this.sampleValues = sampleValues;
        this.validateValues();
    }

    public Number[] getInterleaveValues() {
        return this.interleaveValues;
    }

    public void setInterleaveValues(Number[] interleaveValues) {
        this.interleaveValues = interleaveValues;
        this.validateValues();
    }

    public Number[] getPixel(int x, int y) {
        this.validateCoordinates(x, y);
        Number[] pixel = new Number[this.samplesPerPixel];
        if (this.sampleValues != null) {
            int sampleIndex = this.getSampleIndex(x, y);
            for (int i = 0; i < this.samplesPerPixel; ++i) {
                pixel[i] = this.sampleValues[i][sampleIndex];
            }
        } else {
            int interleaveIndex = this.getInterleaveIndex(x, y);
            for (int i = 0; i < this.samplesPerPixel; ++i) {
                pixel[i] = this.interleaveValues[interleaveIndex++];
            }
        }
        return pixel;
    }

    public void setPixel(int x, int y, Number[] values) {
        this.validateCoordinates(x, y);
        this.validateSample(values.length + 1);
        if (this.sampleValues != null) {
            int sampleIndex = this.getSampleIndex(x, y);
            for (int i = 0; i < this.samplesPerPixel; ++i) {
                this.sampleValues[i][sampleIndex] = values[i];
            }
        } else {
            int interleaveIndex = this.getInterleaveIndex(x, y);
            for (int i = 0; i < this.samplesPerPixel; ++i) {
                this.interleaveValues[interleaveIndex++] = values[i];
            }
        }
    }

    public Number getPixelSample(int sample, int x, int y) {
        this.validateCoordinates(x, y);
        this.validateSample(sample);
        Number pixelSample = null;
        if (this.sampleValues != null) {
            int sampleIndex = this.getSampleIndex(x, y);
            pixelSample = this.sampleValues[sample][sampleIndex];
        } else {
            int interleaveIndex = this.getInterleaveIndex(x, y);
            pixelSample = this.interleaveValues[interleaveIndex + sample];
        }
        return pixelSample;
    }

    public void setPixelSample(int sample, int x, int y, Number value) {
        this.validateCoordinates(x, y);
        this.validateSample(sample);
        if (this.sampleValues != null) {
            int sampleIndex = this.getSampleIndex(x, y);
            this.sampleValues[sample][sampleIndex] = value;
        }
        if (this.interleaveValues != null) {
            int interleaveIndex = this.getInterleaveIndex(x, y);
            this.interleaveValues[interleaveIndex + sample] = value;
        }
    }

    public Number getFirstPixelSample(int x, int y) {
        return this.getPixelSample(0, x, y);
    }

    public void setFirstPixelSample(int x, int y, Number value) {
        this.setPixelSample(0, x, y, value);
    }

    public int getSampleIndex(int x, int y) {
        return y * this.width + x;
    }

    public int getInterleaveIndex(int x, int y) {
        return y * this.width * this.samplesPerPixel + x * this.samplesPerPixel;
    }

    public int size() {
        return this.getNumPixels() * this.sizePixel();
    }

    public int sizePixel() {
        int size = 0;
        for (int i = 0; i < this.samplesPerPixel; ++i) {
            size += this.sizeSample(i);
        }
        return size;
    }

    public int sizeSample(int sample) {
        return this.bitsPerSample.get(sample) / 8;
    }

    private void validateCoordinates(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y > this.height) {
            throw new TiffException("Pixel oustide of raster range. Width: " + this.width + ", Height: " + this.height + ", x: " + x + ", y: " + y);
        }
    }

    private void validateSample(int sample) {
        if (sample < 0 || sample >= this.samplesPerPixel) {
            throw new TiffException("Pixel sample out of bounds. sample: " + sample + ", samples per pixel: " + this.samplesPerPixel);
        }
    }

    public int calculateRowsPerStrip(int planarConfiguration) {
        return this.calculateRowsPerStrip(planarConfiguration, 8000);
    }

    public int calculateRowsPerStrip(int planarConfiguration, int maxBytesPerStrip) {
        Integer rowsPerStrip = null;
        if (planarConfiguration == 1) {
            int bitsPerPixel = 0;
            for (int sampleBits : this.bitsPerSample) {
                bitsPerPixel += sampleBits;
            }
            rowsPerStrip = this.rowsPerStrip(bitsPerPixel, maxBytesPerStrip);
        } else {
            for (int sampleBits : this.bitsPerSample) {
                int rowsPerStripForSample = this.rowsPerStrip(sampleBits, maxBytesPerStrip);
                if (rowsPerStrip != null && rowsPerStripForSample >= rowsPerStrip) continue;
                rowsPerStrip = rowsPerStripForSample;
            }
        }
        return rowsPerStrip;
    }

    private int rowsPerStrip(int bitsPerPixel, int maxBytesPerStrip) {
        int bytesPerPixel = (int)Math.ceil((double)bitsPerPixel / 8.0);
        int bytesPerRow = bytesPerPixel * this.width;
        int rowsPerStrip = Math.max(1, maxBytesPerStrip / bytesPerRow);
        return rowsPerStrip;
    }
}

