/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff.io;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ByteReader {
    private int nextByte = 0;
    private final byte[] bytes;
    private ByteOrder byteOrder = null;

    public ByteReader(byte[] bytes) {
        this(bytes, ByteOrder.BIG_ENDIAN);
    }

    public ByteReader(byte[] bytes, ByteOrder byteOrder) {
        this.bytes = bytes;
        this.byteOrder = byteOrder;
    }

    public int getNextByte() {
        return this.nextByte;
    }

    public void setNextByte(int nextByte) {
        this.nextByte = nextByte;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public boolean hasByte() {
        return this.hasBytes(1);
    }

    public boolean hasByte(int offset) {
        return this.hasBytes(offset, 1);
    }

    public boolean hasBytes(int count) {
        return this.hasBytes(this.nextByte, count);
    }

    public boolean hasBytes(int offset, int count) {
        return offset + count <= this.bytes.length;
    }

    public String readString(int num) throws UnsupportedEncodingException {
        String value = this.readString(this.nextByte, num);
        this.nextByte += num;
        return value;
    }

    public String readString(int offset, int num) throws UnsupportedEncodingException {
        this.verifyRemainingBytes(offset, num);
        String value = null;
        if (num != 1 || this.bytes[offset] != 0) {
            value = new String(this.bytes, offset, num, StandardCharsets.US_ASCII);
        }
        return value;
    }

    public byte readByte() {
        byte value = this.readByte(this.nextByte);
        ++this.nextByte;
        return value;
    }

    public byte readByte(int offset) {
        this.verifyRemainingBytes(offset, 1);
        byte value = this.bytes[offset];
        return value;
    }

    public short readUnsignedByte() {
        short value = this.readUnsignedByte(this.nextByte);
        ++this.nextByte;
        return value;
    }

    public short readUnsignedByte(int offset) {
        return (short)(this.readByte(offset) & 0xFF);
    }

    public byte[] readBytes(int num) {
        byte[] readBytes = this.readBytes(this.nextByte, num);
        this.nextByte += num;
        return readBytes;
    }

    public byte[] readBytes(int offset, int num) {
        this.verifyRemainingBytes(offset, num);
        byte[] readBytes = Arrays.copyOfRange(this.bytes, offset, offset + num);
        return readBytes;
    }

    public short readShort() {
        short value = this.readShort(this.nextByte);
        this.nextByte += 2;
        return value;
    }

    public short readShort(int offset) {
        this.verifyRemainingBytes(offset, 2);
        short value = ByteBuffer.wrap(this.bytes, offset, 2).order(this.byteOrder).getShort();
        return value;
    }

    public int readUnsignedShort() {
        int value = this.readUnsignedShort(this.nextByte);
        this.nextByte += 2;
        return value;
    }

    public int readUnsignedShort(int offset) {
        return this.readShort(offset) & 0xFFFF;
    }

    public int readInt() {
        int value = this.readInt(this.nextByte);
        this.nextByte += 4;
        return value;
    }

    public int readInt(int offset) {
        this.verifyRemainingBytes(offset, 4);
        int value = ByteBuffer.wrap(this.bytes, offset, 4).order(this.byteOrder).getInt();
        return value;
    }

    public long readUnsignedInt() {
        long value = this.readUnsignedInt(this.nextByte);
        this.nextByte += 4;
        return value;
    }

    public long readUnsignedInt(int offset) {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    public float readFloat() {
        float value = this.readFloat(this.nextByte);
        this.nextByte += 4;
        return value;
    }

    public float readFloat(int offset) {
        this.verifyRemainingBytes(offset, 4);
        float value = ByteBuffer.wrap(this.bytes, offset, 4).order(this.byteOrder).getFloat();
        return value;
    }

    public double readDouble() {
        double value = this.readDouble(this.nextByte);
        this.nextByte += 8;
        return value;
    }

    public double readDouble(int offset) {
        this.verifyRemainingBytes(offset, 8);
        double value = ByteBuffer.wrap(this.bytes, offset, 8).order(this.byteOrder).getDouble();
        return value;
    }

    public int byteLength() {
        return this.bytes.length;
    }

    private void verifyRemainingBytes(int offset, int bytesToRead) {
        if (offset + bytesToRead > this.bytes.length) {
            throw new IllegalStateException("No more remaining bytes to read. Total Bytes: " + this.bytes.length + ", Byte offset: " + offset + ", Attempted to read: " + bytesToRead);
        }
    }
}

