/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.geom;

import java.util.ArrayList;
import java.util.List;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryType;

public class GeometryCollection<T extends Geometry>
extends Geometry {
    private List<T> geometries = new ArrayList<T>();

    public GeometryCollection() {
        this(false, false);
    }

    public GeometryCollection(boolean hasZ, boolean hasM) {
        super(GeometryType.GEOMETRYCOLLECTION, hasZ, hasM);
    }

    public GeometryCollection(GeometryCollection<T> geometryCollection) {
        this(geometryCollection.hasZ(), geometryCollection.hasM());
        for (Geometry geometry : geometryCollection.getGeometries()) {
            Geometry geometryCopy = geometry.copy();
            this.addGeometry(geometryCopy);
        }
    }

    protected GeometryCollection(GeometryType type, boolean hasZ, boolean hasM) {
        super(type, hasZ, hasM);
    }

    public List<T> getGeometries() {
        return this.geometries;
    }

    public void setGeometries(List<T> geometries) {
        this.geometries = geometries;
    }

    public void addGeometry(T geometry) {
        this.geometries.add(geometry);
    }

    public int numGeometries() {
        return this.geometries.size();
    }

    @Override
    public Geometry copy() {
        return new GeometryCollection<T>(this);
    }
}

