/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.io;

import java.nio.ByteOrder;
import mil.nga.wkb.geom.CircularString;
import mil.nga.wkb.geom.CompoundCurve;
import mil.nga.wkb.geom.Curve;
import mil.nga.wkb.geom.CurvePolygon;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryCollection;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.LineString;
import mil.nga.wkb.geom.MultiLineString;
import mil.nga.wkb.geom.MultiPoint;
import mil.nga.wkb.geom.MultiPolygon;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.geom.Polygon;
import mil.nga.wkb.geom.PolyhedralSurface;
import mil.nga.wkb.geom.TIN;
import mil.nga.wkb.geom.Triangle;
import mil.nga.wkb.io.ByteReader;
import mil.nga.wkb.util.WkbException;

public class WkbGeometryReader {
    public static Geometry readGeometry(ByteReader reader) {
        Object geometry = WkbGeometryReader.readGeometry(reader, null);
        return geometry;
    }

    public static <T extends Geometry> T readGeometry(ByteReader reader, Class<T> expectedType) {
        byte byteOrderValue = reader.readByte();
        ByteOrder byteOrder = byteOrderValue == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ByteOrder originalByteOrder = reader.getByteOrder();
        reader.setByteOrder(byteOrder);
        int geometryTypeWkbCode = reader.readInt();
        int geometryTypeCode = geometryTypeWkbCode % 1000;
        int geometryTypeMode = geometryTypeWkbCode / 1000;
        boolean hasZ = false;
        boolean hasM = false;
        switch (geometryTypeMode) {
            case 0: {
                break;
            }
            case 1: {
                hasZ = true;
                break;
            }
            case 2: {
                hasM = true;
                break;
            }
            case 3: {
                hasZ = true;
                hasM = true;
            }
        }
        GeometryType geometryType = GeometryType.fromCode(geometryTypeCode);
        Geometry geometry = null;
        switch (geometryType) {
            case GEOMETRY: {
                throw new WkbException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POINT: {
                geometry = WkbGeometryReader.readPoint(reader, hasZ, hasM);
                break;
            }
            case LINESTRING: {
                geometry = WkbGeometryReader.readLineString(reader, hasZ, hasM);
                break;
            }
            case POLYGON: {
                geometry = WkbGeometryReader.readPolygon(reader, hasZ, hasM);
                break;
            }
            case MULTIPOINT: {
                geometry = WkbGeometryReader.readMultiPoint(reader, hasZ, hasM);
                break;
            }
            case MULTILINESTRING: {
                geometry = WkbGeometryReader.readMultiLineString(reader, hasZ, hasM);
                break;
            }
            case MULTIPOLYGON: {
                geometry = WkbGeometryReader.readMultiPolygon(reader, hasZ, hasM);
                break;
            }
            case GEOMETRYCOLLECTION: {
                geometry = WkbGeometryReader.readGeometryCollection(reader, hasZ, hasM);
                break;
            }
            case CIRCULARSTRING: {
                geometry = WkbGeometryReader.readCircularString(reader, hasZ, hasM);
                break;
            }
            case COMPOUNDCURVE: {
                geometry = WkbGeometryReader.readCompoundCurve(reader, hasZ, hasM);
                break;
            }
            case CURVEPOLYGON: {
                geometry = WkbGeometryReader.readCurvePolygon(reader, hasZ, hasM);
                break;
            }
            case MULTICURVE: {
                throw new WkbException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case MULTISURFACE: {
                throw new WkbException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case CURVE: {
                throw new WkbException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case SURFACE: {
                throw new WkbException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POLYHEDRALSURFACE: {
                geometry = WkbGeometryReader.readPolyhedralSurface(reader, hasZ, hasM);
                break;
            }
            case TIN: {
                geometry = WkbGeometryReader.readTIN(reader, hasZ, hasM);
                break;
            }
            case TRIANGLE: {
                geometry = WkbGeometryReader.readTriangle(reader, hasZ, hasM);
                break;
            }
            default: {
                throw new WkbException("Geometry Type not supported: " + (Object)((Object)geometryType));
            }
        }
        if (expectedType != null && geometry != null && !expectedType.isAssignableFrom(geometry.getClass())) {
            throw new WkbException("Unexpected Geometry Type. Expected: " + expectedType.getSimpleName() + ", Actual: " + geometry.getClass().getSimpleName());
        }
        reader.setByteOrder(originalByteOrder);
        Geometry result = geometry;
        return (T)result;
    }

    public static Point readPoint(ByteReader reader, boolean hasZ, boolean hasM) {
        double x = reader.readDouble();
        double y = reader.readDouble();
        Point point = new Point(hasZ, hasM, x, y);
        if (hasZ) {
            double z = reader.readDouble();
            point.setZ(z);
        }
        if (hasM) {
            double m = reader.readDouble();
            point.setM(m);
        }
        return point;
    }

    public static LineString readLineString(ByteReader reader, boolean hasZ, boolean hasM) {
        LineString lineString = new LineString(hasZ, hasM);
        int numPoints = reader.readInt();
        for (int i = 0; i < numPoints; ++i) {
            Point point = WkbGeometryReader.readPoint(reader, hasZ, hasM);
            lineString.addPoint(point);
        }
        return lineString;
    }

    public static Polygon readPolygon(ByteReader reader, boolean hasZ, boolean hasM) {
        Polygon polygon = new Polygon(hasZ, hasM);
        int numRings = reader.readInt();
        for (int i = 0; i < numRings; ++i) {
            LineString ring = WkbGeometryReader.readLineString(reader, hasZ, hasM);
            polygon.addRing(ring);
        }
        return polygon;
    }

    public static MultiPoint readMultiPoint(ByteReader reader, boolean hasZ, boolean hasM) {
        MultiPoint multiPoint = new MultiPoint(hasZ, hasM);
        int numPoints = reader.readInt();
        for (int i = 0; i < numPoints; ++i) {
            Point point = WkbGeometryReader.readGeometry(reader, Point.class);
            multiPoint.addPoint(point);
        }
        return multiPoint;
    }

    public static MultiLineString readMultiLineString(ByteReader reader, boolean hasZ, boolean hasM) {
        MultiLineString multiLineString = new MultiLineString(hasZ, hasM);
        int numLineStrings = reader.readInt();
        for (int i = 0; i < numLineStrings; ++i) {
            LineString lineString = WkbGeometryReader.readGeometry(reader, LineString.class);
            multiLineString.addLineString(lineString);
        }
        return multiLineString;
    }

    public static MultiPolygon readMultiPolygon(ByteReader reader, boolean hasZ, boolean hasM) {
        MultiPolygon multiPolygon = new MultiPolygon(hasZ, hasM);
        int numPolygons = reader.readInt();
        for (int i = 0; i < numPolygons; ++i) {
            Polygon polygon = WkbGeometryReader.readGeometry(reader, Polygon.class);
            multiPolygon.addPolygon(polygon);
        }
        return multiPolygon;
    }

    public static GeometryCollection<Geometry> readGeometryCollection(ByteReader reader, boolean hasZ, boolean hasM) {
        GeometryCollection<Geometry> geometryCollection = new GeometryCollection<Geometry>(hasZ, hasM);
        int numGeometries = reader.readInt();
        for (int i = 0; i < numGeometries; ++i) {
            Geometry geometry = WkbGeometryReader.readGeometry(reader, Geometry.class);
            geometryCollection.addGeometry(geometry);
        }
        return geometryCollection;
    }

    public static CircularString readCircularString(ByteReader reader, boolean hasZ, boolean hasM) {
        CircularString circularString = new CircularString(hasZ, hasM);
        int numPoints = reader.readInt();
        for (int i = 0; i < numPoints; ++i) {
            Point point = WkbGeometryReader.readPoint(reader, hasZ, hasM);
            circularString.addPoint(point);
        }
        return circularString;
    }

    public static CompoundCurve readCompoundCurve(ByteReader reader, boolean hasZ, boolean hasM) {
        CompoundCurve compoundCurve = new CompoundCurve(hasZ, hasM);
        int numLineStrings = reader.readInt();
        for (int i = 0; i < numLineStrings; ++i) {
            LineString lineString = WkbGeometryReader.readGeometry(reader, LineString.class);
            compoundCurve.addLineString(lineString);
        }
        return compoundCurve;
    }

    public static CurvePolygon<Curve> readCurvePolygon(ByteReader reader, boolean hasZ, boolean hasM) {
        CurvePolygon<Curve> curvePolygon = new CurvePolygon<Curve>(hasZ, hasM);
        int numRings = reader.readInt();
        for (int i = 0; i < numRings; ++i) {
            Curve ring = WkbGeometryReader.readGeometry(reader, Curve.class);
            curvePolygon.addRing(ring);
        }
        return curvePolygon;
    }

    public static PolyhedralSurface readPolyhedralSurface(ByteReader reader, boolean hasZ, boolean hasM) {
        PolyhedralSurface polyhedralSurface = new PolyhedralSurface(hasZ, hasM);
        int numPolygons = reader.readInt();
        for (int i = 0; i < numPolygons; ++i) {
            Polygon polygon = WkbGeometryReader.readGeometry(reader, Polygon.class);
            polyhedralSurface.addPolygon(polygon);
        }
        return polyhedralSurface;
    }

    public static TIN readTIN(ByteReader reader, boolean hasZ, boolean hasM) {
        TIN tin = new TIN(hasZ, hasM);
        int numPolygons = reader.readInt();
        for (int i = 0; i < numPolygons; ++i) {
            Polygon polygon = WkbGeometryReader.readGeometry(reader, Polygon.class);
            tin.addPolygon(polygon);
        }
        return tin;
    }

    public static Triangle readTriangle(ByteReader reader, boolean hasZ, boolean hasM) {
        Triangle triangle = new Triangle(hasZ, hasM);
        int numRings = reader.readInt();
        for (int i = 0; i < numRings; ++i) {
            LineString ring = WkbGeometryReader.readLineString(reader, hasZ, hasM);
            triangle.addRing(ring);
        }
        return triangle;
    }
}

