/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.util;

import java.util.List;
import mil.nga.wkb.geom.CompoundCurve;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryCollection;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.LineString;
import mil.nga.wkb.geom.MultiLineString;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.util.GeometryUtils;
import mil.nga.wkb.util.WkbException;

public class CentroidCurve {
    private Point sum = new Point();
    private double totalLength = 0.0;

    public CentroidCurve() {
    }

    public CentroidCurve(Geometry geometry) {
        this.add(geometry);
    }

    public void add(Geometry geometry) {
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case LINESTRING: 
            case CIRCULARSTRING: {
                this.add((LineString)geometry);
                break;
            }
            case MULTILINESTRING: {
                MultiLineString multiLineString = (MultiLineString)geometry;
                this.addLineStrings(multiLineString.getLineStrings());
                break;
            }
            case COMPOUNDCURVE: {
                CompoundCurve compoundCurve = (CompoundCurve)geometry;
                this.addLineStrings(compoundCurve.getLineStrings());
                break;
            }
            case GEOMETRYCOLLECTION: {
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                List geometries = geomCollection.getGeometries();
                for (Geometry subGeometry : geometries) {
                    this.add(subGeometry);
                }
                break;
            }
            case POINT: 
            case MULTIPOINT: {
                break;
            }
            default: {
                throw new WkbException("Unsupported " + this.getClass().getSimpleName() + " Geometry Type: " + (Object)((Object)geometryType));
            }
        }
    }

    private void addLineStrings(List<LineString> lineStrings) {
        for (LineString lineString : lineStrings) {
            this.add(lineString);
        }
    }

    private void add(LineString lineString) {
        this.add(lineString.getPoints());
    }

    private void add(List<Point> points) {
        for (int i = 0; i < points.size() - 1; ++i) {
            Point point = points.get(i);
            Point nextPoint = points.get(i + 1);
            double length = GeometryUtils.distance(point, nextPoint);
            this.totalLength += length;
            double midX = (point.getX() + nextPoint.getX()) / 2.0;
            this.sum.setX(this.sum.getX() + length * midX);
            double midY = (point.getY() + nextPoint.getY()) / 2.0;
            this.sum.setY(this.sum.getY() + length * midY);
        }
    }

    public Point getCentroid() {
        Point centroid = new Point(this.sum.getX() / this.totalLength, this.sum.getY() / this.totalLength);
        return centroid;
    }
}

