/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.util;

import java.util.List;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryCollection;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.MultiPoint;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.util.WkbException;

public class CentroidPoint {
    private int count = 0;
    private Point sum = new Point();

    public CentroidPoint() {
    }

    public CentroidPoint(Geometry geometry) {
        this.add(geometry);
    }

    public void add(Geometry geometry) {
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POINT: {
                this.add((Point)geometry);
                break;
            }
            case MULTIPOINT: {
                MultiPoint multiPoint = (MultiPoint)geometry;
                for (Point point : multiPoint.getPoints()) {
                    this.add(point);
                }
                break;
            }
            case GEOMETRYCOLLECTION: {
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                List geometries = geomCollection.getGeometries();
                for (Geometry subGeometry : geometries) {
                    this.add(subGeometry);
                }
                break;
            }
            default: {
                throw new WkbException("Unsupported " + this.getClass().getSimpleName() + " Geometry Type: " + (Object)((Object)geometryType));
            }
        }
    }

    private void add(Point point) {
        ++this.count;
        this.sum.setX(this.sum.getX() + point.getX());
        this.sum.setY(this.sum.getY() + point.getY());
    }

    public Point getCentroid() {
        Point centroid = new Point(this.sum.getX() / (double)this.count, this.sum.getY() / (double)this.count);
        return centroid;
    }
}

