/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.util;

import java.util.List;
import mil.nga.wkb.geom.CircularString;
import mil.nga.wkb.geom.CompoundCurve;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryCollection;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.LineString;
import mil.nga.wkb.geom.MultiLineString;
import mil.nga.wkb.geom.MultiPoint;
import mil.nga.wkb.geom.MultiPolygon;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.geom.Polygon;
import mil.nga.wkb.geom.PolyhedralSurface;
import mil.nga.wkb.geom.TIN;
import mil.nga.wkb.geom.Triangle;
import mil.nga.wkb.util.CentroidCurve;
import mil.nga.wkb.util.CentroidPoint;
import mil.nga.wkb.util.CentroidSurface;
import mil.nga.wkb.util.WkbException;

public class GeometryUtils {
    public static int getDimension(Geometry geometry) {
        int dimension = -1;
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POINT: 
            case MULTIPOINT: {
                dimension = 0;
                break;
            }
            case LINESTRING: 
            case MULTILINESTRING: 
            case CIRCULARSTRING: 
            case COMPOUNDCURVE: {
                dimension = 1;
                break;
            }
            case POLYGON: 
            case CURVEPOLYGON: 
            case MULTIPOLYGON: 
            case POLYHEDRALSURFACE: 
            case TIN: 
            case TRIANGLE: {
                dimension = 2;
                break;
            }
            case GEOMETRYCOLLECTION: {
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                List geometries = geomCollection.getGeometries();
                for (Geometry subGeometry : geometries) {
                    dimension = Math.max(dimension, GeometryUtils.getDimension(subGeometry));
                }
                break;
            }
            default: {
                throw new WkbException("Unsupported Geometry Type: " + (Object)((Object)geometryType));
            }
        }
        return dimension;
    }

    public static double distance(Point point1, Point point2) {
        double diffX = point1.getX() - point2.getX();
        double diffY = point1.getY() - point2.getY();
        double distance = Math.sqrt(diffX * diffX + diffY * diffY);
        return distance;
    }

    public static Point getCentroid(Geometry geometry) {
        Point centroid = null;
        int dimension = GeometryUtils.getDimension(geometry);
        switch (dimension) {
            case 0: {
                CentroidPoint point = new CentroidPoint(geometry);
                centroid = point.getCentroid();
                break;
            }
            case 1: {
                CentroidCurve curve = new CentroidCurve(geometry);
                centroid = curve.getCentroid();
                break;
            }
            case 2: {
                CentroidSurface surface = new CentroidSurface(geometry);
                centroid = surface.getCentroid();
            }
        }
        return centroid;
    }

    public static void minimizeGeometry(Geometry geometry, double maxX) {
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case LINESTRING: {
                GeometryUtils.minimize((LineString)geometry, maxX);
                break;
            }
            case POLYGON: {
                GeometryUtils.minimize((Polygon)geometry, maxX);
                break;
            }
            case MULTILINESTRING: {
                GeometryUtils.minimize((MultiLineString)geometry, maxX);
                break;
            }
            case MULTIPOLYGON: {
                GeometryUtils.minimize((MultiPolygon)geometry, maxX);
                break;
            }
            case CIRCULARSTRING: {
                GeometryUtils.minimize((CircularString)geometry, maxX);
                break;
            }
            case COMPOUNDCURVE: {
                GeometryUtils.minimize((CompoundCurve)geometry, maxX);
                break;
            }
            case POLYHEDRALSURFACE: {
                GeometryUtils.minimize((PolyhedralSurface)geometry, maxX);
                break;
            }
            case TIN: {
                GeometryUtils.minimize((TIN)geometry, maxX);
                break;
            }
            case TRIANGLE: {
                GeometryUtils.minimize((Triangle)geometry, maxX);
                break;
            }
            case GEOMETRYCOLLECTION: {
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                for (Geometry subGeometry : geomCollection.getGeometries()) {
                    GeometryUtils.minimizeGeometry(subGeometry, maxX);
                }
                break;
            }
        }
    }

    private static void minimize(LineString lineString, double maxX) {
        List<Point> points = lineString.getPoints();
        if (points.size() > 1) {
            Point point = points.get(0);
            for (int i = 1; i < points.size(); ++i) {
                Point nextPoint = points.get(i);
                if (point.getX() < nextPoint.getX()) {
                    if (!(nextPoint.getX() - point.getX() > point.getX() - nextPoint.getX() + maxX * 2.0)) continue;
                    nextPoint.setX(nextPoint.getX() - maxX * 2.0);
                    continue;
                }
                if (!(point.getX() > nextPoint.getX()) || !(point.getX() - nextPoint.getX() > nextPoint.getX() - point.getX() + maxX * 2.0)) continue;
                nextPoint.setX(nextPoint.getX() + maxX * 2.0);
            }
        }
    }

    private static void minimize(MultiLineString multiLineString, double maxX) {
        List<LineString> lineStrings = multiLineString.getLineStrings();
        for (LineString lineString : lineStrings) {
            GeometryUtils.minimize(lineString, maxX);
        }
    }

    private static void minimize(Polygon polygon, double maxX) {
        for (LineString ring : polygon.getRings()) {
            GeometryUtils.minimize(ring, maxX);
        }
    }

    private static void minimize(MultiPolygon multiPolygon, double maxX) {
        List<Polygon> polygons = multiPolygon.getPolygons();
        for (Polygon polygon : polygons) {
            GeometryUtils.minimize(polygon, maxX);
        }
    }

    private static void minimize(CompoundCurve compoundCurve, double maxX) {
        for (LineString lineString : compoundCurve.getLineStrings()) {
            GeometryUtils.minimize(lineString, maxX);
        }
    }

    private static void minimize(PolyhedralSurface polyhedralSurface, double maxX) {
        for (Polygon polygon : polyhedralSurface.getPolygons()) {
            GeometryUtils.minimize(polygon, maxX);
        }
    }

    public static void normalizeGeometry(Geometry geometry, double maxX) {
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POINT: {
                GeometryUtils.normalize((Point)geometry, maxX);
                break;
            }
            case LINESTRING: {
                GeometryUtils.normalize((LineString)geometry, maxX);
                break;
            }
            case POLYGON: {
                GeometryUtils.normalize((Polygon)geometry, maxX);
                break;
            }
            case MULTIPOINT: {
                GeometryUtils.normalize((MultiPoint)geometry, maxX);
                break;
            }
            case MULTILINESTRING: {
                GeometryUtils.normalize((MultiLineString)geometry, maxX);
                break;
            }
            case MULTIPOLYGON: {
                GeometryUtils.normalize((MultiPolygon)geometry, maxX);
                break;
            }
            case CIRCULARSTRING: {
                GeometryUtils.normalize((CircularString)geometry, maxX);
                break;
            }
            case COMPOUNDCURVE: {
                GeometryUtils.normalize((CompoundCurve)geometry, maxX);
                break;
            }
            case POLYHEDRALSURFACE: {
                GeometryUtils.normalize((PolyhedralSurface)geometry, maxX);
                break;
            }
            case TIN: {
                GeometryUtils.normalize((TIN)geometry, maxX);
                break;
            }
            case TRIANGLE: {
                GeometryUtils.normalize((Triangle)geometry, maxX);
                break;
            }
            case GEOMETRYCOLLECTION: {
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                for (Geometry subGeometry : geomCollection.getGeometries()) {
                    GeometryUtils.normalizeGeometry(subGeometry, maxX);
                }
                break;
            }
        }
    }

    private static void normalize(Point point, double maxX) {
        if (point.getX() < -maxX) {
            point.setX(point.getX() + maxX * 2.0);
        } else if (point.getX() > maxX) {
            point.setX(point.getX() - maxX * 2.0);
        }
    }

    private static void normalize(MultiPoint multiPoint, double maxX) {
        List<Point> points = multiPoint.getPoints();
        for (Point point : points) {
            GeometryUtils.normalize(point, maxX);
        }
    }

    private static void normalize(LineString lineString, double maxX) {
        for (Point point : lineString.getPoints()) {
            GeometryUtils.normalize(point, maxX);
        }
    }

    private static void normalize(MultiLineString multiLineString, double maxX) {
        List<LineString> lineStrings = multiLineString.getLineStrings();
        for (LineString lineString : lineStrings) {
            GeometryUtils.normalize(lineString, maxX);
        }
    }

    private static void normalize(Polygon polygon, double maxX) {
        for (LineString ring : polygon.getRings()) {
            GeometryUtils.normalize(ring, maxX);
        }
    }

    private static void normalize(MultiPolygon multiPolygon, double maxX) {
        List<Polygon> polygons = multiPolygon.getPolygons();
        for (Polygon polygon : polygons) {
            GeometryUtils.normalize(polygon, maxX);
        }
    }

    private static void normalize(CompoundCurve compoundCurve, double maxX) {
        for (LineString lineString : compoundCurve.getLineStrings()) {
            GeometryUtils.normalize(lineString, maxX);
        }
    }

    private static void normalize(PolyhedralSurface polyhedralSurface, double maxX) {
        for (Polygon polygon : polyhedralSurface.getPolygons()) {
            GeometryUtils.normalize(polygon, maxX);
        }
    }
}

