/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mil.nga.wkb.geom.CircularString;
import mil.nga.wkb.geom.CompoundCurve;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryCollection;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.LineString;
import mil.nga.wkb.geom.MultiLineString;
import mil.nga.wkb.geom.MultiPoint;
import mil.nga.wkb.geom.MultiPolygon;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.geom.Polygon;
import mil.nga.wkb.geom.PolyhedralSurface;
import mil.nga.wkb.geom.TIN;
import mil.nga.wkb.geom.Triangle;

public class GeometryJSONCompatible {
    public static Object getJSONCompatibleGeometry(Geometry geometry) {
        HashMap jsonObject = new HashMap();
        ArrayList<Object> geometryObject = null;
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POINT: {
                geometryObject = GeometryJSONCompatible.getPoint((Point)geometry);
                break;
            }
            case LINESTRING: {
                geometryObject = GeometryJSONCompatible.getLineString((LineString)geometry);
                break;
            }
            case POLYGON: {
                geometryObject = GeometryJSONCompatible.getPolygon((Polygon)geometry);
                break;
            }
            case MULTIPOINT: {
                geometryObject = GeometryJSONCompatible.getMultiPoint((MultiPoint)geometry);
                break;
            }
            case MULTILINESTRING: {
                geometryObject = GeometryJSONCompatible.getMultiLineString((MultiLineString)geometry);
                break;
            }
            case MULTIPOLYGON: {
                geometryObject = GeometryJSONCompatible.getMultiPolygon((MultiPolygon)geometry);
                break;
            }
            case CIRCULARSTRING: {
                geometryObject = GeometryJSONCompatible.getLineString((CircularString)geometry);
                break;
            }
            case COMPOUNDCURVE: {
                geometryObject = GeometryJSONCompatible.getCompoundCurve((CompoundCurve)geometry);
                break;
            }
            case POLYHEDRALSURFACE: {
                geometryObject = GeometryJSONCompatible.getPolyhedralSurface((PolyhedralSurface)geometry);
                break;
            }
            case TIN: {
                geometryObject = GeometryJSONCompatible.getPolyhedralSurface((TIN)geometry);
                break;
            }
            case TRIANGLE: {
                geometryObject = GeometryJSONCompatible.getPolygon((Triangle)geometry);
                break;
            }
            case GEOMETRYCOLLECTION: {
                ArrayList<Object> jsonGeoCollectionObject = new ArrayList<Object>();
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                List geometries = geomCollection.getGeometries();
                for (int i = 0; i < geometries.size(); ++i) {
                    Geometry subGeometry = (Geometry)geometries.get(i);
                    jsonGeoCollectionObject.add(GeometryJSONCompatible.getJSONCompatibleGeometry(subGeometry));
                }
                geometryObject = jsonGeoCollectionObject;
                break;
            }
        }
        if (geometryObject != null) {
            jsonObject.put(geometryType.getName(), geometryObject);
        }
        return jsonObject;
    }

    private static Object getPoint(Point point) {
        HashMap<String, Double> jsonObject = new HashMap<String, Double>();
        jsonObject.put("x", point.getX());
        jsonObject.put("y", point.getY());
        if (point.hasZ()) {
            jsonObject.put("z", point.getZ());
        }
        if (point.hasM()) {
            jsonObject.put("m", point.getM());
        }
        return jsonObject;
    }

    private static Object getMultiPoint(MultiPoint multiPoint) {
        ArrayList<Object> jsonObject = new ArrayList<Object>();
        List<Point> points = multiPoint.getPoints();
        for (int i = 0; i < points.size(); ++i) {
            Point point = points.get(i);
            jsonObject.add(GeometryJSONCompatible.getPoint(point));
        }
        return jsonObject;
    }

    private static Object getLineString(LineString lineString) {
        ArrayList<Object> jsonObject = new ArrayList<Object>();
        for (Point point : lineString.getPoints()) {
            jsonObject.add(GeometryJSONCompatible.getPoint(point));
        }
        return jsonObject;
    }

    private static Object getMultiLineString(MultiLineString multiLineString) {
        ArrayList<Object> jsonObject = new ArrayList<Object>();
        List<LineString> lineStrings = multiLineString.getLineStrings();
        for (int i = 0; i < lineStrings.size(); ++i) {
            LineString lineString = lineStrings.get(i);
            jsonObject.add(GeometryJSONCompatible.getLineString(lineString));
        }
        return jsonObject;
    }

    private static Object getPolygon(Polygon polygon) {
        ArrayList<Object> jsonObject = new ArrayList<Object>();
        List rings = polygon.getRings();
        for (int i = 0; i < rings.size(); ++i) {
            LineString ring = (LineString)rings.get(i);
            jsonObject.add(GeometryJSONCompatible.getLineString(ring));
        }
        return jsonObject;
    }

    private static Object getMultiPolygon(MultiPolygon multiPolygon) {
        ArrayList<Object> jsonObject = new ArrayList<Object>();
        List<Polygon> polygons = multiPolygon.getPolygons();
        for (int i = 0; i < polygons.size(); ++i) {
            Polygon polygon = polygons.get(i);
            jsonObject.add(GeometryJSONCompatible.getPolygon(polygon));
        }
        return jsonObject;
    }

    private static Object getCompoundCurve(CompoundCurve compoundCurve) {
        ArrayList<Object> jsonObject = new ArrayList<Object>();
        List<LineString> lineStrings = compoundCurve.getLineStrings();
        for (int i = 0; i < lineStrings.size(); ++i) {
            LineString lineString = lineStrings.get(i);
            jsonObject.add(GeometryJSONCompatible.getLineString(lineString));
        }
        return jsonObject;
    }

    private static Object getPolyhedralSurface(PolyhedralSurface polyhedralSurface) {
        ArrayList<Object> jsonObject = new ArrayList<Object>();
        List<Polygon> polygons = polyhedralSurface.getPolygons();
        for (int i = 0; i < polygons.size(); ++i) {
            Polygon polygon = polygons.get(i);
            jsonObject.add(GeometryJSONCompatible.getPolygon(polygon));
        }
        return jsonObject;
    }
}

