/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.geom;

import mil.nga.wkb.geom.GeometryType;

public abstract class Geometry {
    private final GeometryType geometryType;
    private final boolean hasZ;
    private final boolean hasM;

    protected Geometry(GeometryType geometryType, boolean hasZ, boolean hasM) {
        this.geometryType = geometryType;
        this.hasZ = hasZ;
        this.hasM = hasM;
    }

    public GeometryType getGeometryType() {
        return this.geometryType;
    }

    public boolean hasZ() {
        return this.hasZ;
    }

    public boolean hasM() {
        return this.hasM;
    }

    public int getWkbCode() {
        int code = this.getGeometryType().getCode();
        if (this.hasZ) {
            code += 1000;
        }
        if (this.hasM) {
            code += 2000;
        }
        return code;
    }

    public abstract Geometry copy();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.geometryType == null ? 0 : this.geometryType.hashCode());
        result = 31 * result + (this.hasM ? 1231 : 1237);
        result = 31 * result + (this.hasZ ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Geometry other = (Geometry)obj;
        if (this.geometryType != other.geometryType) {
            return false;
        }
        if (this.hasM != other.hasM) {
            return false;
        }
        return this.hasZ == other.hasZ;
    }
}

