/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.geom;

import java.util.ArrayList;
import java.util.List;
import mil.nga.wkb.geom.Curve;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.LineString;
import mil.nga.wkb.geom.MultiLineString;
import mil.nga.wkb.geom.MultiPoint;
import mil.nga.wkb.geom.MultiPolygon;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.geom.Polygon;
import mil.nga.wkb.geom.Surface;
import mil.nga.wkb.util.GeometryUtils;
import mil.nga.wkb.util.WkbException;

public class GeometryCollection<T extends Geometry>
extends Geometry {
    private List<T> geometries = new ArrayList<T>();

    public GeometryCollection() {
        this(false, false);
    }

    public GeometryCollection(boolean hasZ, boolean hasM) {
        super(GeometryType.GEOMETRYCOLLECTION, hasZ, hasM);
    }

    public GeometryCollection(List<T> geometries) {
        this(GeometryUtils.hasZ(geometries), GeometryUtils.hasM(geometries));
        this.setGeometries(geometries);
    }

    public GeometryCollection(GeometryCollection<T> geometryCollection) {
        this(geometryCollection.hasZ(), geometryCollection.hasM());
        for (Geometry geometry : geometryCollection.getGeometries()) {
            Geometry geometryCopy = geometry.copy();
            this.addGeometry(geometryCopy);
        }
    }

    protected GeometryCollection(GeometryType type, boolean hasZ, boolean hasM) {
        super(type, hasZ, hasM);
    }

    public List<T> getGeometries() {
        return this.geometries;
    }

    public void setGeometries(List<T> geometries) {
        this.geometries = geometries;
    }

    public void addGeometry(T geometry) {
        this.geometries.add(geometry);
    }

    public int numGeometries() {
        return this.geometries.size();
    }

    public GeometryType getCollectionType() {
        GeometryType geometryType = this.getGeometryType();
        switch (geometryType) {
            case MULTIPOINT: 
            case MULTILINESTRING: 
            case MULTIPOLYGON: {
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                if (this.isMultiPoint()) {
                    geometryType = GeometryType.MULTIPOINT;
                    break;
                }
                if (this.isMultiLineString()) {
                    geometryType = GeometryType.MULTILINESTRING;
                    break;
                }
                if (this.isMultiPolygon()) {
                    geometryType = GeometryType.MULTIPOLYGON;
                    break;
                }
                if (this.isMultiCurve()) {
                    geometryType = GeometryType.MULTICURVE;
                    break;
                }
                if (!this.isMultiSurface()) break;
                geometryType = GeometryType.MULTISURFACE;
                break;
            }
            default: {
                throw new WkbException("Unexpected Geometry Collection Type: " + (Object)((Object)geometryType));
            }
        }
        return geometryType;
    }

    public boolean isMultiPoint() {
        boolean isMultiPoint = this instanceof MultiPoint;
        if (!isMultiPoint) {
            isMultiPoint = this.isCollectionOfType(Point.class);
        }
        return isMultiPoint;
    }

    public MultiPoint getAsMultiPoint() {
        MultiPoint newMultiPoint;
        MultiPoint multiPoint = this instanceof MultiPoint ? (MultiPoint)this : (newMultiPoint = new MultiPoint(this.geometries));
        return multiPoint;
    }

    public boolean isMultiLineString() {
        boolean isMultiLineString = this instanceof MultiLineString;
        if (!isMultiLineString) {
            isMultiLineString = this.isCollectionOfType(LineString.class);
        }
        return isMultiLineString;
    }

    public MultiLineString getAsMultiLineString() {
        MultiLineString newMultiLineString;
        MultiLineString multiLineString = this instanceof MultiLineString ? (MultiLineString)this : (newMultiLineString = new MultiLineString(this.geometries));
        return multiLineString;
    }

    public boolean isMultiPolygon() {
        boolean isMultiPolygon = this instanceof MultiPolygon;
        if (!isMultiPolygon) {
            isMultiPolygon = this.isCollectionOfType(Polygon.class);
        }
        return isMultiPolygon;
    }

    public MultiPolygon getAsMultiPolygon() {
        MultiPolygon newMultiPolygon;
        MultiPolygon multiPolygon = this instanceof MultiPolygon ? (MultiPolygon)this : (newMultiPolygon = new MultiPolygon(this.geometries));
        return multiPolygon;
    }

    public boolean isMultiCurve() {
        boolean isMultiCurve = this instanceof MultiLineString;
        if (!isMultiCurve) {
            isMultiCurve = this.isCollectionOfType(Curve.class);
        }
        return isMultiCurve;
    }

    public GeometryCollection<Curve> getAsMultiCurve() {
        GeometryCollection<Curve> multiCurve;
        if (this instanceof MultiLineString) {
            GeometryCollection<Curve> castMultiCurve;
            multiCurve = castMultiCurve = new GeometryCollection<Curve>(this.getGeometries());
        } else {
            GeometryCollection<Curve> castMultiCurve = this;
            multiCurve = castMultiCurve;
            if (!multiCurve.getGeometries().isEmpty()) {
                Curve curve = (Curve)multiCurve.getGeometries().get(0);
            }
        }
        return multiCurve;
    }

    public boolean isMultiSurface() {
        boolean isMultiSurface = this instanceof MultiPolygon;
        if (!isMultiSurface) {
            isMultiSurface = this.isCollectionOfType(Surface.class);
        }
        return isMultiSurface;
    }

    public GeometryCollection<Surface> getAsMultiSurface() {
        GeometryCollection<Surface> multiSurface;
        if (this instanceof MultiPolygon) {
            GeometryCollection<Surface> castMultiSurface;
            multiSurface = castMultiSurface = new GeometryCollection<Surface>(this.getGeometries());
        } else {
            GeometryCollection<Surface> castMultiSurface = this;
            multiSurface = castMultiSurface;
            if (!multiSurface.getGeometries().isEmpty()) {
                Surface surface = (Surface)multiSurface.getGeometries().get(0);
            }
        }
        return multiSurface;
    }

    public GeometryCollection<Geometry> getAsGeometryCollection() {
        GeometryCollection<T> castGeometryCollection;
        GeometryCollection<T> geometryCollection = GeometryCollection.class.equals(this.getClass()) ? (castGeometryCollection = this) : (castGeometryCollection = new GeometryCollection<T>(this.getGeometries()));
        return geometryCollection;
    }

    private <TType extends Geometry> boolean isCollectionOfType(Class<TType> type) {
        boolean isType = true;
        for (Geometry geometry : this.geometries) {
            if (type.isAssignableFrom(geometry.getClass())) continue;
            isType = false;
            break;
        }
        return isType;
    }

    @Override
    public Geometry copy() {
        return new GeometryCollection<T>(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.geometries == null ? 0 : this.geometries.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeometryCollection other = (GeometryCollection)obj;
        return !(this.geometries == null ? other.geometries != null : !this.geometries.equals(other.geometries));
    }
}

