/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.geom;

import java.util.ArrayList;
import java.util.List;
import mil.nga.wkb.geom.Curve;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.Point;

public class LineString
extends Curve {
    private List<Point> points = new ArrayList<Point>();

    public LineString() {
        this(false, false);
    }

    public LineString(boolean hasZ, boolean hasM) {
        super(GeometryType.LINESTRING, hasZ, hasM);
    }

    public LineString(LineString lineString) {
        this(lineString.hasZ(), lineString.hasM());
        for (Point point : lineString.getPoints()) {
            this.addPoint((Point)point.copy());
        }
    }

    protected LineString(GeometryType type, boolean hasZ, boolean hasM) {
        super(type, hasZ, hasM);
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    public void addPoint(Point point) {
        this.points.add(point);
    }

    public int numPoints() {
        return this.points.size();
    }

    @Override
    public Geometry copy() {
        return new LineString(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.points == null ? 0 : this.points.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineString other = (LineString)obj;
        return !(this.points == null ? other.points != null : !this.points.equals(other.points));
    }
}

