/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.geom;

import java.util.List;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryCollection;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.util.GeometryUtils;

public class MultiPoint
extends GeometryCollection<Point> {
    public MultiPoint() {
        this(false, false);
    }

    public MultiPoint(boolean hasZ, boolean hasM) {
        super(GeometryType.MULTIPOINT, hasZ, hasM);
    }

    public MultiPoint(List<Point> points) {
        this(GeometryUtils.hasZ(points), GeometryUtils.hasM(points));
        this.setPoints(points);
    }

    public MultiPoint(MultiPoint multiPoint) {
        this(multiPoint.hasZ(), multiPoint.hasM());
        for (Point point : multiPoint.getPoints()) {
            this.addPoint((Point)point.copy());
        }
    }

    public List<Point> getPoints() {
        return this.getGeometries();
    }

    public void setPoints(List<Point> points) {
        this.setGeometries(points);
    }

    public void addPoint(Point point) {
        this.addGeometry(point);
    }

    public int numPoints() {
        return this.numGeometries();
    }

    @Override
    public Geometry copy() {
        return new MultiPoint(this);
    }
}

