/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.geom.extended;

import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryCollection;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.util.WkbException;

public class ExtendedGeometryCollection<T extends Geometry>
extends GeometryCollection<T> {
    private GeometryType geometryType = GeometryType.GEOMETRYCOLLECTION;

    public ExtendedGeometryCollection(GeometryCollection<T> geometryCollection) {
        super(GeometryType.GEOMETRYCOLLECTION, geometryCollection.hasZ(), geometryCollection.hasM());
        this.setGeometries(geometryCollection.getGeometries());
        this.updateGeometryType();
    }

    public ExtendedGeometryCollection(ExtendedGeometryCollection<T> extendedGeometryCollection) {
        super(GeometryType.GEOMETRYCOLLECTION, extendedGeometryCollection.hasZ(), extendedGeometryCollection.hasM());
        for (Geometry geometry : extendedGeometryCollection.getGeometries()) {
            Geometry geometryCopy = geometry.copy();
            this.addGeometry(geometryCopy);
        }
        this.geometryType = extendedGeometryCollection.getGeometryType();
    }

    public void updateGeometryType() {
        GeometryType geometryType = this.getCollectionType();
        switch (geometryType) {
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                break;
            }
            case MULTIPOINT: {
                geometryType = GeometryType.GEOMETRYCOLLECTION;
                break;
            }
            case MULTILINESTRING: {
                geometryType = GeometryType.MULTICURVE;
                break;
            }
            case MULTIPOLYGON: {
                geometryType = GeometryType.MULTISURFACE;
                break;
            }
            default: {
                throw new WkbException("Unsupported extended geometry collection geometry type: " + (Object)((Object)geometryType));
            }
        }
        this.geometryType = geometryType;
    }

    @Override
    public GeometryType getGeometryType() {
        return this.geometryType;
    }

    @Override
    public Geometry copy() {
        return new ExtendedGeometryCollection<T>(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.geometryType == null ? 0 : this.geometryType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtendedGeometryCollection other = (ExtendedGeometryCollection)obj;
        return this.geometryType == other.geometryType;
    }
}

