/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.util;

import java.util.ArrayList;
import java.util.List;
import mil.nga.wkb.geom.CircularString;
import mil.nga.wkb.geom.CompoundCurve;
import mil.nga.wkb.geom.Curve;
import mil.nga.wkb.geom.CurvePolygon;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryCollection;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.LineString;
import mil.nga.wkb.geom.MultiLineString;
import mil.nga.wkb.geom.MultiPoint;
import mil.nga.wkb.geom.MultiPolygon;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.geom.Polygon;
import mil.nga.wkb.geom.PolyhedralSurface;
import mil.nga.wkb.geom.TIN;
import mil.nga.wkb.geom.Triangle;
import mil.nga.wkb.util.WkbException;
import mil.nga.wkb.util.centroid.CentroidCurve;
import mil.nga.wkb.util.centroid.CentroidPoint;
import mil.nga.wkb.util.centroid.CentroidSurface;

public class GeometryUtils {
    public static final double DEFAULT_EPSILON = 1.0E-15;

    public static int getDimension(Geometry geometry) {
        int dimension = -1;
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POINT: 
            case MULTIPOINT: {
                dimension = 0;
                break;
            }
            case LINESTRING: 
            case MULTILINESTRING: 
            case CIRCULARSTRING: 
            case COMPOUNDCURVE: {
                dimension = 1;
                break;
            }
            case POLYGON: 
            case CURVEPOLYGON: 
            case MULTIPOLYGON: 
            case POLYHEDRALSURFACE: 
            case TIN: 
            case TRIANGLE: {
                dimension = 2;
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                List geometries = geomCollection.getGeometries();
                for (Geometry subGeometry : geometries) {
                    dimension = Math.max(dimension, GeometryUtils.getDimension(subGeometry));
                }
                break;
            }
            default: {
                throw new WkbException("Unsupported Geometry Type: " + (Object)((Object)geometryType));
            }
        }
        return dimension;
    }

    public static double distance(Point point1, Point point2) {
        double diffX = point1.getX() - point2.getX();
        double diffY = point1.getY() - point2.getY();
        double distance = Math.sqrt(diffX * diffX + diffY * diffY);
        return distance;
    }

    public static Point getCentroid(Geometry geometry) {
        Point centroid = null;
        int dimension = GeometryUtils.getDimension(geometry);
        switch (dimension) {
            case 0: {
                CentroidPoint point = new CentroidPoint(geometry);
                centroid = point.getCentroid();
                break;
            }
            case 1: {
                CentroidCurve curve = new CentroidCurve(geometry);
                centroid = curve.getCentroid();
                break;
            }
            case 2: {
                CentroidSurface surface = new CentroidSurface(geometry);
                centroid = surface.getCentroid();
            }
        }
        return centroid;
    }

    public static void minimizeGeometry(Geometry geometry, double maxX) {
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case LINESTRING: {
                GeometryUtils.minimize((LineString)geometry, maxX);
                break;
            }
            case POLYGON: {
                GeometryUtils.minimize((Polygon)geometry, maxX);
                break;
            }
            case MULTILINESTRING: {
                GeometryUtils.minimize((MultiLineString)geometry, maxX);
                break;
            }
            case MULTIPOLYGON: {
                GeometryUtils.minimize((MultiPolygon)geometry, maxX);
                break;
            }
            case CIRCULARSTRING: {
                GeometryUtils.minimize((CircularString)geometry, maxX);
                break;
            }
            case COMPOUNDCURVE: {
                GeometryUtils.minimize((CompoundCurve)geometry, maxX);
                break;
            }
            case CURVEPOLYGON: {
                CurvePolygon curvePolygon = (CurvePolygon)geometry;
                GeometryUtils.minimize(curvePolygon, maxX);
                break;
            }
            case POLYHEDRALSURFACE: {
                GeometryUtils.minimize((PolyhedralSurface)geometry, maxX);
                break;
            }
            case TIN: {
                GeometryUtils.minimize((TIN)geometry, maxX);
                break;
            }
            case TRIANGLE: {
                GeometryUtils.minimize((Triangle)geometry, maxX);
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                for (Geometry subGeometry : geomCollection.getGeometries()) {
                    GeometryUtils.minimizeGeometry(subGeometry, maxX);
                }
                break;
            }
        }
    }

    private static void minimize(LineString lineString, double maxX) {
        List<Point> points = lineString.getPoints();
        if (points.size() > 1) {
            Point point = points.get(0);
            for (int i = 1; i < points.size(); ++i) {
                Point nextPoint = points.get(i);
                if (point.getX() < nextPoint.getX()) {
                    if (!(nextPoint.getX() - point.getX() > point.getX() - nextPoint.getX() + maxX * 2.0)) continue;
                    nextPoint.setX(nextPoint.getX() - maxX * 2.0);
                    continue;
                }
                if (!(point.getX() > nextPoint.getX()) || !(point.getX() - nextPoint.getX() > nextPoint.getX() - point.getX() + maxX * 2.0)) continue;
                nextPoint.setX(nextPoint.getX() + maxX * 2.0);
            }
        }
    }

    private static void minimize(MultiLineString multiLineString, double maxX) {
        List<LineString> lineStrings = multiLineString.getLineStrings();
        for (LineString lineString : lineStrings) {
            GeometryUtils.minimize(lineString, maxX);
        }
    }

    private static void minimize(Polygon polygon, double maxX) {
        for (LineString ring : polygon.getRings()) {
            GeometryUtils.minimize(ring, maxX);
        }
    }

    private static void minimize(MultiPolygon multiPolygon, double maxX) {
        List<Polygon> polygons = multiPolygon.getPolygons();
        for (Polygon polygon : polygons) {
            GeometryUtils.minimize(polygon, maxX);
        }
    }

    private static void minimize(CompoundCurve compoundCurve, double maxX) {
        for (LineString lineString : compoundCurve.getLineStrings()) {
            GeometryUtils.minimize(lineString, maxX);
        }
    }

    private static void minimize(CurvePolygon<Curve> curvePolygon, double maxX) {
        for (Curve ring : curvePolygon.getRings()) {
            GeometryUtils.minimizeGeometry(ring, maxX);
        }
    }

    private static void minimize(PolyhedralSurface polyhedralSurface, double maxX) {
        for (Polygon polygon : polyhedralSurface.getPolygons()) {
            GeometryUtils.minimize(polygon, maxX);
        }
    }

    public static void normalizeGeometry(Geometry geometry, double maxX) {
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POINT: {
                GeometryUtils.normalize((Point)geometry, maxX);
                break;
            }
            case LINESTRING: {
                GeometryUtils.normalize((LineString)geometry, maxX);
                break;
            }
            case POLYGON: {
                GeometryUtils.normalize((Polygon)geometry, maxX);
                break;
            }
            case MULTIPOINT: {
                GeometryUtils.normalize((MultiPoint)geometry, maxX);
                break;
            }
            case MULTILINESTRING: {
                GeometryUtils.normalize((MultiLineString)geometry, maxX);
                break;
            }
            case MULTIPOLYGON: {
                GeometryUtils.normalize((MultiPolygon)geometry, maxX);
                break;
            }
            case CIRCULARSTRING: {
                GeometryUtils.normalize((CircularString)geometry, maxX);
                break;
            }
            case COMPOUNDCURVE: {
                GeometryUtils.normalize((CompoundCurve)geometry, maxX);
                break;
            }
            case CURVEPOLYGON: {
                CurvePolygon curvePolygon = (CurvePolygon)geometry;
                GeometryUtils.normalize(curvePolygon, maxX);
                break;
            }
            case POLYHEDRALSURFACE: {
                GeometryUtils.normalize((PolyhedralSurface)geometry, maxX);
                break;
            }
            case TIN: {
                GeometryUtils.normalize((TIN)geometry, maxX);
                break;
            }
            case TRIANGLE: {
                GeometryUtils.normalize((Triangle)geometry, maxX);
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                for (Geometry subGeometry : geomCollection.getGeometries()) {
                    GeometryUtils.normalizeGeometry(subGeometry, maxX);
                }
                break;
            }
        }
    }

    private static void normalize(Point point, double maxX) {
        if (point.getX() < -maxX) {
            point.setX(point.getX() + maxX * 2.0);
        } else if (point.getX() > maxX) {
            point.setX(point.getX() - maxX * 2.0);
        }
    }

    private static void normalize(MultiPoint multiPoint, double maxX) {
        List<Point> points = multiPoint.getPoints();
        for (Point point : points) {
            GeometryUtils.normalize(point, maxX);
        }
    }

    private static void normalize(LineString lineString, double maxX) {
        for (Point point : lineString.getPoints()) {
            GeometryUtils.normalize(point, maxX);
        }
    }

    private static void normalize(MultiLineString multiLineString, double maxX) {
        List<LineString> lineStrings = multiLineString.getLineStrings();
        for (LineString lineString : lineStrings) {
            GeometryUtils.normalize(lineString, maxX);
        }
    }

    private static void normalize(Polygon polygon, double maxX) {
        for (LineString ring : polygon.getRings()) {
            GeometryUtils.normalize(ring, maxX);
        }
    }

    private static void normalize(MultiPolygon multiPolygon, double maxX) {
        List<Polygon> polygons = multiPolygon.getPolygons();
        for (Polygon polygon : polygons) {
            GeometryUtils.normalize(polygon, maxX);
        }
    }

    private static void normalize(CompoundCurve compoundCurve, double maxX) {
        for (LineString lineString : compoundCurve.getLineStrings()) {
            GeometryUtils.normalize(lineString, maxX);
        }
    }

    private static void normalize(CurvePolygon<Curve> curvePolygon, double maxX) {
        for (Curve ring : curvePolygon.getRings()) {
            GeometryUtils.normalizeGeometry(ring, maxX);
        }
    }

    private static void normalize(PolyhedralSurface polyhedralSurface, double maxX) {
        for (Polygon polygon : polyhedralSurface.getPolygons()) {
            GeometryUtils.normalize(polygon, maxX);
        }
    }

    public static List<Point> simplifyPoints(List<Point> points, double tolerance) {
        return GeometryUtils.simplifyPoints(points, tolerance, 0, points.size() - 1);
    }

    private static List<Point> simplifyPoints(List<Point> points, double tolerance, int startIndex, int endIndex) {
        List<Point> result = null;
        double dmax = 0.0;
        int index = 0;
        Point startPoint = points.get(startIndex);
        Point endPoint = points.get(endIndex);
        for (int i = startIndex + 1; i < endIndex; ++i) {
            Point point = points.get(i);
            double d = GeometryUtils.perpendicularDistance(point, startPoint, endPoint);
            if (!(d > dmax)) continue;
            index = i;
            dmax = d;
        }
        if (dmax > tolerance) {
            List<Point> recResults1 = GeometryUtils.simplifyPoints(points, tolerance, startIndex, index);
            List<Point> recResults2 = GeometryUtils.simplifyPoints(points, tolerance, index, endIndex);
            result = recResults1.subList(0, recResults1.size() - 1);
            result.addAll(recResults2);
        } else {
            result = new ArrayList<Point>();
            result.add(startPoint);
            result.add(endPoint);
        }
        return result;
    }

    public static double perpendicularDistance(Point point, Point lineStart, Point lineEnd) {
        double y2;
        double x2;
        double x = point.getX();
        double y = point.getY();
        double startX = lineStart.getX();
        double startY = lineStart.getY();
        double endX = lineEnd.getX();
        double endY = lineEnd.getY();
        double vX = endX - startX;
        double vY = endY - startY;
        double wX = x - startX;
        double wY = y - startY;
        double c1 = wX * vX + wY * vY;
        double c2 = vX * vX + vY * vY;
        if (c1 <= 0.0) {
            x2 = startX;
            y2 = startY;
        } else if (c2 <= c1) {
            x2 = endX;
            y2 = endY;
        } else {
            double b = c1 / c2;
            x2 = startX + b * vX;
            y2 = startY + b * vY;
        }
        double distance = Math.sqrt(Math.pow(x2 - x, 2.0) + Math.pow(y2 - y, 2.0));
        return distance;
    }

    public static boolean pointInPolygon(Point point, Polygon polygon) {
        return GeometryUtils.pointInPolygon(point, polygon, 1.0E-15);
    }

    public static boolean pointInPolygon(Point point, Polygon polygon, double epsilon) {
        boolean contains = false;
        List rings = polygon.getRings();
        if (!rings.isEmpty() && (contains = GeometryUtils.pointInPolygon(point, (LineString)rings.get(0), epsilon))) {
            for (int i = 1; i < rings.size(); ++i) {
                if (!GeometryUtils.pointInPolygon(point, (LineString)rings.get(i), epsilon)) continue;
                contains = false;
                break;
            }
        }
        return contains;
    }

    public static boolean pointInPolygon(Point point, LineString ring) {
        return GeometryUtils.pointInPolygon(point, ring, 1.0E-15);
    }

    public static boolean pointInPolygon(Point point, LineString ring, double epsilon) {
        return GeometryUtils.pointInPolygon(point, ring.getPoints(), epsilon);
    }

    public static boolean pointInPolygon(Point point, List<Point> points) {
        return GeometryUtils.pointInPolygon(point, points, 1.0E-15);
    }

    public static boolean pointInPolygon(Point point, List<Point> points, double epsilon) {
        boolean contains = false;
        int i = 0;
        int j = points.size() - 1;
        if (GeometryUtils.closedPolygon(points)) {
            j = i++;
        }
        while (i < points.size()) {
            Point point1 = points.get(i);
            Point point2 = points.get(j);
            if (Math.abs(point1.getX() - point.getX()) <= epsilon && Math.abs(point1.getY() - point.getY()) <= epsilon) {
                contains = true;
                break;
            }
            if (point1.getY() > point.getY() != point2.getY() > point.getY() && point.getX() < (point2.getX() - point1.getX()) * (point.getY() - point1.getY()) / (point2.getY() - point1.getY()) + point1.getX()) {
                contains = !contains;
            }
            j = i++;
        }
        if (!contains) {
            contains = GeometryUtils.pointOnPolygonEdge(point, points);
        }
        return contains;
    }

    public static boolean pointOnPolygonEdge(Point point, Polygon polygon) {
        return GeometryUtils.pointOnPolygonEdge(point, polygon, 1.0E-15);
    }

    public static boolean pointOnPolygonEdge(Point point, Polygon polygon, double epsilon) {
        return polygon.numRings() > 0 && GeometryUtils.pointOnPolygonEdge(point, (LineString)polygon.getRings().get(0), epsilon);
    }

    public static boolean pointOnPolygonEdge(Point point, LineString ring) {
        return GeometryUtils.pointOnPolygonEdge(point, ring, 1.0E-15);
    }

    public static boolean pointOnPolygonEdge(Point point, LineString ring, double epsilon) {
        return GeometryUtils.pointOnPolygonEdge(point, ring.getPoints(), epsilon);
    }

    public static boolean pointOnPolygonEdge(Point point, List<Point> points) {
        return GeometryUtils.pointOnPolygonEdge(point, points, 1.0E-15);
    }

    public static boolean pointOnPolygonEdge(Point point, List<Point> points, double epsilon) {
        return GeometryUtils.pointOnPath(point, points, epsilon, !GeometryUtils.closedPolygon(points));
    }

    public static boolean closedPolygon(Polygon polygon) {
        return polygon.numRings() > 0 && GeometryUtils.closedPolygon((LineString)polygon.getRings().get(0));
    }

    public static boolean closedPolygon(LineString ring) {
        return GeometryUtils.closedPolygon(ring.getPoints());
    }

    public static boolean closedPolygon(List<Point> points) {
        boolean closed = false;
        if (!points.isEmpty()) {
            Point first = points.get(0);
            Point last = points.get(points.size() - 1);
            closed = first.getX() == last.getX() && first.getY() == last.getY();
        }
        return closed;
    }

    public static boolean pointOnLine(Point point, LineString line) {
        return GeometryUtils.pointOnLine(point, line, 1.0E-15);
    }

    public static boolean pointOnLine(Point point, LineString line, double epsilon) {
        return GeometryUtils.pointOnLine(point, line.getPoints(), epsilon);
    }

    public static boolean pointOnLine(Point point, List<Point> points) {
        return GeometryUtils.pointOnLine(point, points, 1.0E-15);
    }

    public static boolean pointOnLine(Point point, List<Point> points, double epsilon) {
        return GeometryUtils.pointOnPath(point, points, epsilon, false);
    }

    public static boolean pointOnPath(Point point, Point point1, Point point2) {
        return GeometryUtils.pointOnPath(point, point1, point2, 1.0E-15);
    }

    public static boolean pointOnPath(Point point, Point point1, Point point2, double epsilon) {
        double length21;
        double lengthP1;
        double yP1;
        boolean contains = false;
        double x21 = point2.getX() - point1.getX();
        double y21 = point2.getY() - point1.getY();
        double xP1 = point.getX() - point1.getX();
        double dp = xP1 * x21 + (yP1 = point.getY() - point1.getY()) * y21;
        if (dp >= 0.0 && (lengthP1 = xP1 * xP1 + yP1 * yP1) <= (length21 = x21 * x21 + y21 * y21)) {
            contains = Math.abs(dp * dp - lengthP1 * length21) <= epsilon;
        }
        return contains;
    }

    private static boolean pointOnPath(Point point, List<Point> points, double epsilon, boolean circular) {
        boolean onPath = false;
        int i = 0;
        int j = points.size() - 1;
        if (!circular) {
            j = i++;
        }
        while (i < points.size()) {
            Point point2;
            Point point1 = points.get(i);
            if (GeometryUtils.pointOnPath(point, point1, point2 = points.get(j), epsilon)) {
                onPath = true;
                break;
            }
            j = i++;
        }
        return onPath;
    }

    public static <T extends Geometry> boolean hasZ(List<T> geometries) {
        boolean hasZ = false;
        for (Geometry geometry : geometries) {
            if (!geometry.hasZ()) continue;
            hasZ = true;
            break;
        }
        return hasZ;
    }

    public static <T extends Geometry> boolean hasM(List<T> geometries) {
        boolean hasM = false;
        for (Geometry geometry : geometries) {
            if (!geometry.hasM()) continue;
            hasM = true;
            break;
        }
        return hasM;
    }
}

