/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.scan;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import ml.alternet.facet.Presentable;
import ml.alternet.misc.CharArray;
import ml.alternet.misc.Thrower;
import ml.alternet.scan.Readable;
import ml.alternet.scan.Scanner;
import ml.alternet.scan.StringConstraint;
import ml.alternet.util.StringBuilderUtil;

public class EnumValues<T>
implements Readable<T>,
Presentable {
    int start = 0;
    T val;
    Set<EnumValues<T>> values;
    CharArray chars;
    private static int FLAGS = 5393;

    public static <T extends Enum<T>> EnumValues<T> from(Class<T> values) {
        Set enumValues = Arrays.stream(values.getEnumConstants()).map(e -> new EnumValues<Enum>((Enum)e)).collect(Collectors.toSet());
        EnumValues result = new EnumValues(enumValues);
        return result.dispatch(0).wrap();
    }

    public static EnumValues<String> from(String ... values) {
        return EnumValues.from(Arrays.stream(values));
    }

    public static EnumValues<String> from(Stream<String> values) {
        Set enumValues = values.map(e -> new EnumValues<String>((String)e)).collect(Collectors.toSet());
        EnumValues result = new EnumValues(enumValues);
        return result.dispatch(0).wrap();
    }

    EnumValues<T> wrap() {
        if (this.chars != null || this.values == null) {
            HashSet<EnumValues<T>> set = new HashSet<EnumValues<T>>();
            set.add(this);
            EnumValues<Object> wrapper = new EnumValues<Object>(null);
            wrapper.values = set;
            return wrapper;
        }
        return this;
    }

    EnumValues(Set<EnumValues<?>> enumValues) {
        if (enumValues.size() == 1) {
            this.val = ((EnumValues)enumValues.stream().findAny().get()).val;
        } else {
            this.values = enumValues;
        }
    }

    EnumValues(T val) {
        this.val = val;
    }

    EnumValues(char c, Set<EnumValues<T>> enumValues, int start) {
        this.start = start;
        if (enumValues.size() == 1) {
            this.val = ((EnumValues)enumValues.stream().findAny().get()).val;
        } else {
            this.values = enumValues;
            this.chars = new CharArray(new char[1], 0, 0);
            this.chars.append(c);
        }
    }

    void push(char c) {
        if (this.chars == null) {
            this.chars = new CharArray(new char[1], 0, 0);
        }
        this.chars.append(c);
    }

    public String toString() {
        return (this.start == 0 ? "" : "(" + this.start + ") ") + (this.chars == null ? "" : "'" + this.chars + "' -> ") + (this.val == null ? "" : "'" + this.val + "'") + (this.values == null ? "" : this.values + "");
    }

    boolean hasNextChars(Scanner scanner) {
        try {
            if (this.chars == null) {
                if (this.start == 0) {
                    return scanner.hasNextString(this.val.toString(), true);
                }
                String nextChars = this.val.toString().substring(this.start);
                return scanner.hasNextString(nextChars, true);
            }
            if (this.chars.length() == 1) {
                return scanner.lookAhead() == this.chars.charAt(0);
            }
            return scanner.hasNextString((CharSequence)this.chars, false);
        }
        catch (IOException e) {
            return (Boolean)Thrower.doThrow((Exception)e);
        }
    }

    @Override
    public Optional<T> nextValue(Scanner scanner) throws IOException {
        return this.nextValuePart(scanner, 0);
    }

    Optional<T> nextValuePart(Scanner scanner, int charPos) throws IOException {
        Optional result = Optional.empty();
        Optional<EnumValues> value = this.values.stream().filter(e -> e.hasNextChars(scanner)).findFirst();
        if (value.isPresent()) {
            String strValue;
            EnumValues enumValue = value.get();
            if (enumValue.values == null) {
                result = Optional.of(enumValue.val);
            } else {
                scanner.mark();
                int l = scanner.skipNextString(new StringConstraint.ReadLength(enumValue.chars.length()));
                result = enumValue.nextValuePart(scanner, charPos + l);
                if (result.isPresent()) {
                    scanner.consume();
                } else {
                    scanner.cancel();
                }
            }
            if (!result.isPresent() && enumValue.val != null && ((strValue = enumValue.val.toString()).length() == charPos || scanner.hasNextString(strValue.substring(charPos), true))) {
                result = Optional.of(enumValue.val);
            }
        }
        return result;
    }

    EnumValues<T> dispatch(int index) {
        Map enumByChar;
        Map dispatchable;
        int i;
        boolean sameString;
        if (this.values == null) {
            return this;
        }
        if (this.values.size() == 1) {
            return (EnumValues)this.values.stream().findAny().get();
        }
        do {
            i = index;
            dispatchable = this.values.stream().collect(Collectors.partitioningBy(e -> e.val.toString().length() > i, Collectors.toSet()));
            enumByChar = dispatchable.get(true).stream().collect(Collectors.groupingBy(e -> Character.valueOf(e.val.toString().charAt(i)), TreeMap::new, Collectors.toSet()));
            boolean bl = sameString = enumByChar.size() == 1 && dispatchable.get(false).isEmpty();
            if (!sameString) continue;
            enumByChar.forEach((c, e) -> this.push(c.charValue()));
            ++index;
        } while (sameString);
        i = index;
        Set enumValues = enumByChar.entrySet().stream().map(e -> new EnumValues(((Character)e.getKey()).charValue(), (Set)e.getValue(), i)).map(e -> e.dispatch(i + 1)).collect(Collectors.toSet());
        if (dispatchable.get(false).isEmpty()) {
            if (enumValues.size() == 1) {
                return (EnumValues)enumValues.stream().findAny().get();
            }
        } else {
            this.val = ((EnumValues)dispatchable.get((Object)Boolean.valueOf((boolean)false)).stream().findAny().get()).val;
        }
        this.values = enumValues;
        return this;
    }

    public StringBuilder toPrettyString(StringBuilder buf) {
        return (StringBuilder)this.values().map(o -> "'" + o.toString() + "'").sorted(Comparator.comparing(String::length).thenComparing(s -> s)).collect(StringBuilderUtil.collectorOf((CharSequence)"( ", (CharSequence)" | ", (CharSequence)" )", (StringBuilder)buf));
    }

    public Stream<T> values() {
        return Stream.concat(Optional.ofNullable(this.val).map(Stream::of).orElseGet(Stream::empty), StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, FLAGS){
            Spliterator<T> stream;
            {
                this.stream = Optional.ofNullable(EnumValues.this.values).map(values -> values.stream().flatMap(v -> v.values())).orElseGet(() -> Stream.empty()).spliterator();
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                return this.stream.tryAdvance(action);
            }
        }, false));
    }
}

