/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.scan;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import ml.alternet.scan.Constraint;
import ml.alternet.scan.Scanner;

public interface NumberConstraint
extends Constraint {
    public static final NumberConstraint NO_CONSTRAINT = new NumberConstraint(){

        @Override
        public boolean stopCondition(StringBuffer buf, int sourceIndex, int dotIndex, int exponentIndex, Scanner scanner) throws IOException {
            return false;
        }

        @Override
        public Class<? extends Number> getNumberType() {
            return null;
        }
    };
    public static final NumberConstraint BYTE_CONSTRAINT = new NumberClassConstraint(){

        @Override
        public boolean stopCondition(StringBuffer buf, int sourceIndex, int dotIndex, int exponentIndex, Scanner scanner) throws IOException {
            return this.checkInteger(scanner) || this.checkDigits(buf, scanner, NumberConstraint.MIN_BYTE, NumberConstraint.MAX_BYTE);
        }

        @Override
        public Class<? extends Number> getNumberType() {
            return Byte.class;
        }
    };
    public static final NumberConstraint SHORT_CONSTRAINT = new NumberClassConstraint(){

        @Override
        public boolean stopCondition(StringBuffer buf, int sourceIndex, int dotIndex, int exponentIndex, Scanner scanner) throws IOException {
            return this.checkInteger(scanner) || this.checkDigits(buf, scanner, NumberConstraint.MIN_SHORT, NumberConstraint.MAX_SHORT);
        }

        @Override
        public Class<? extends Number> getNumberType() {
            return Short.class;
        }
    };
    public static final NumberConstraint INT_CONSTRAINT = new NumberClassConstraint(){

        @Override
        public boolean stopCondition(StringBuffer buf, int sourceIndex, int dotIndex, int exponentIndex, Scanner scanner) throws IOException {
            return this.checkInteger(scanner) || this.checkDigits(buf, scanner, NumberConstraint.MIN_INTEGER, NumberConstraint.MAX_INTEGER);
        }

        @Override
        public Class<? extends Number> getNumberType() {
            return Integer.class;
        }
    };
    public static final NumberConstraint INTEGER_CONSTRAINT = new NumberClassConstraint(){

        @Override
        public boolean stopCondition(StringBuffer buf, int sourceIndex, int dotIndex, int exponentIndex, Scanner scanner) throws IOException {
            return this.checkInteger(scanner);
        }

        @Override
        public Class<? extends Number> getNumberType() {
            return BigInteger.class;
        }
    };
    public static final NumberConstraint LONG_CONSTRAINT = new NumberClassConstraint(){

        @Override
        public boolean stopCondition(StringBuffer buf, int sourceIndex, int dotIndex, int exponentIndex, Scanner scanner) throws IOException {
            return this.checkInteger(scanner) || this.checkDigits(buf, scanner, NumberConstraint.MIN_LONG, NumberConstraint.MAX_LONG);
        }

        @Override
        public Class<? extends Number> getNumberType() {
            return Long.class;
        }
    };
    public static final NumberConstraint DECIMAL_CONSTRAINT = new NumberClassConstraint(){

        @Override
        public boolean stopCondition(StringBuffer buf, int sourceIndex, int dotIndex, int exponentIndex, Scanner scanner) throws IOException {
            return this.checkExponent(scanner);
        }

        @Override
        public Class<? extends Number> getNumberType() {
            return BigDecimal.class;
        }
    };
    public static final NumberConstraint DOUBLE_CONSTRAINT = new NumberConstraint(){

        @Override
        public Class<? extends Number> getNumberType() {
            return Double.class;
        }

        @Override
        public boolean stopCondition(StringBuffer buf, int sourceIndex, int dotIndex, int exponentIndex, Scanner scanner) throws IOException {
            return false;
        }
    };
    public static final NumberConstraint FLOAT_CONSTRAINT = new NumberConstraint(){

        @Override
        public Class<? extends Number> getNumberType() {
            return Float.class;
        }

        @Override
        public boolean stopCondition(StringBuffer buf, int sourceIndex, int dotIndex, int exponentIndex, Scanner scanner) throws IOException {
            return false;
        }
    };
    public static final String MIN_BYTE = "-128";
    public static final String MAX_BYTE = "127";
    public static final String MIN_SHORT = "-32768";
    public static final String MAX_SHORT = "32767";
    public static final String MIN_INTEGER = "-2147483648";
    public static final String MAX_INTEGER = "2147483647";
    public static final String MIN_LONG = "-9223372036854775808";
    public static final String MAX_LONG = "9223372036854775807";

    public boolean stopCondition(StringBuffer var1, int var2, int var3, int var4, Scanner var5) throws IOException;

    public Class<? extends Number> getNumberType();

    public static class Type
    implements NumberConstraint {
        private Class<? extends Number> clazz;

        public Type(Class<? extends Number> numberClass) {
            this.clazz = numberClass;
        }

        @Override
        public Class<? extends Number> getNumberType() {
            return this.clazz;
        }

        @Override
        public boolean stopCondition(StringBuffer buf, int sourceIndex, int dotIndex, int exponentIndex, Scanner scanner) throws IOException {
            return false;
        }
    }

    public static abstract class NumberClassConstraint
    implements NumberConstraint {
        public boolean checkInteger(Scanner scanner) throws IOException {
            return scanner.hasNextChar(".Ee", false);
        }

        public boolean checkExponent(Scanner scanner) throws IOException {
            return scanner.hasNextChar("Ee", false);
        }

        public boolean checkDigits(StringBuffer buf, Scanner scanner, String min, String max) throws IOException {
            int i;
            boolean neg;
            int bl = buf.length();
            boolean bl2 = neg = bl > 0 && buf.charAt(0) == '-';
            if (neg && min == null || !neg && max == null) {
                return false;
            }
            String number = "" + scanner.lookAhead();
            int n = i = neg ? 1 : 0;
            while (i < bl) {
                if (buf.charAt(i) != '0') {
                    number = buf.substring(i) + scanner.lookAhead();
                    break;
                }
                ++i;
            }
            int l = number.length();
            if (neg) {
                max = min.substring(1);
            }
            if (l > max.length()) {
                return true;
            }
            if (l < max.length()) {
                return false;
            }
            for (int i2 = 0; i2 < max.length(); ++i2) {
                char mc;
                char nc = number.charAt(i2);
                if (nc > (mc = max.charAt(i2))) {
                    return true;
                }
                if (nc >= mc) continue;
                return false;
            }
            return false;
        }
    }
}

