/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.scan;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import ml.alternet.io.NoCloseReader;
import ml.alternet.io.ReaderAggregator;
import ml.alternet.misc.Thrower;
import ml.alternet.scan.Scanner;

public class ReaderScanner
extends Scanner {
    private Reader reader;
    private int saveNext;
    public int limit = 8192;

    public ReaderScanner(Reader reader) throws IOException, IllegalArgumentException {
        assert (reader.markSupported());
        if (!reader.markSupported()) {
            throw new IllegalArgumentException("The given reader doesn't support marks.");
        }
        this.reader = reader;
        this.state.source.read();
    }

    @Override
    public void read() throws IOException {
        if (this.state.end) {
            this.state.next = -1;
        } else {
            this.state.next = this.reader.read();
            ++this.state.cursor;
            if (this.state.next == -1) {
                this.state.end = true;
            } else {
                if (Character.isHighSurrogate((char)this.state.next)) {
                    char c = (char)this.reader.read();
                    this.state.next = Character.toCodePoint((char)this.state.next, c);
                    ++this.state.cursor;
                }
                this.state.end = false;
                if (this.state.cursors.isEmpty()) {
                    this.state.cursor = 0;
                }
            }
        }
    }

    @Override
    public void mark() {
        if (this.state.cursors.isEmpty()) {
            this.saveNext = this.state.next;
            try {
                this.reader.mark(this.limit);
            }
            catch (IOException e) {
                Thrower.doThrow((Exception)e);
            }
            this.state.source.push(0);
        } else {
            this.state.source.push(this.state.cursor);
        }
    }

    @Override
    public void cancel() throws IllegalStateException {
        if (this.state.cursors.isEmpty()) {
            throw new IllegalStateException("Can't cancel the reading since no position was marked.");
        }
        try {
            this.state.cursor = this.state.source.pop();
            this.reader.reset();
            if (this.state.cursor == 0) {
                this.state.next = this.saveNext;
            }
            if (!this.state.cursors.isEmpty()) {
                this.reader.mark(this.limit);
                if (this.state.cursor > 0) {
                    this.reader.skip(this.state.cursor - Character.charCount(this.state.next));
                    this.state.next = (char)this.reader.read();
                    if (Character.isHighSurrogate((char)this.state.next)) {
                        char c = (char)this.reader.read();
                        this.state.next = Character.toCodePoint((char)this.state.next, c);
                        ++this.state.cursor;
                    }
                }
            }
            this.state.end = this.state.next == -1;
        }
        catch (IOException e) {
            Thrower.doThrow((Exception)e);
        }
    }

    @Override
    public void consume() throws IllegalStateException {
        if (this.state.cursors.isEmpty()) {
            throw new IllegalStateException("Can't consume characters since no position was marked.");
        }
        this.state.source.pop();
        if (this.state.cursors.isEmpty()) {
            try {
                this.reader.reset();
                this.reader.skip(this.state.cursor);
                this.state.cursor = 0;
            }
            catch (IOException e) {
                Thrower.doThrow((Exception)e);
            }
        }
    }

    @Override
    public Optional<Reader> getRemainder() {
        if (this.state.end) {
            return Optional.empty();
        }
        int c = this.state.next;
        this.state.next = -1;
        this.state.end = true;
        return Optional.of(new ReaderAggregator(new Reader[]{new StringReader(new String(Character.toChars(c))), this.state.cursors.isEmpty() ? this.reader : new NoCloseReader(this.reader)}));
    }

    @Override
    public Optional<String> getRemainderString() throws IOException {
        Optional<Reader> reader = this.getRemainder();
        if (reader.isPresent()) {
            return Optional.of(ReaderScanner.readAll(reader.get()));
        }
        return Optional.empty();
    }

    public static String readAll(Reader input) throws IOException {
        int n;
        StringBuilder out = new StringBuilder(8192);
        char[] c = new char[8192];
        while ((n = input.read(c)) != -1) {
            out.append(c, 0, n);
        }
        input.close();
        return out.toString();
    }

    public String toString() {
        return this.state.toString();
    }
}

