/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.scan;

import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.Spliterators;
import java.util.Stack;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import ml.alternet.facet.Rewindable;
import ml.alternet.facet.Trackable;
import ml.alternet.misc.CharRange;
import ml.alternet.misc.Position;
import ml.alternet.misc.Thrower;
import ml.alternet.scan.EnumValues;
import ml.alternet.scan.NumberConstraint;
import ml.alternet.scan.ReaderScanner;
import ml.alternet.scan.StringConstraint;
import ml.alternet.scan.StringScanner;
import ml.alternet.scan.TrackableScanner;
import ml.alternet.util.NumberUtil;

public abstract class Scanner
implements Trackable,
Rewindable {
    State state = new State(this);

    public static Scanner of(CharSequence input) {
        return (Scanner)Thrower.safeCall(() -> new StringScanner(input));
    }

    public static Scanner of(Reader input) throws IllegalArgumentException, IOException {
        return new ReaderScanner(input);
    }

    public TrackableScanner asTrackable() throws IOException {
        return new TrackableScanner(this);
    }

    public Optional<Position> getPosition() {
        return Optional.empty();
    }

    public int nextString(StringConstraint constraint, StringBuilder buf) throws IOException {
        int targetLength = 0;
        this.state.sourceIndex = 0;
        while (!this.state.end && !constraint.stopCondition(this.state.sourceIndex, targetLength, this)) {
            ++this.state.sourceIndex;
            targetLength += constraint.append(this.state.sourceIndex, targetLength, this, buf);
            this.state.source.read();
        }
        return targetLength;
    }

    public Optional<String> nextString(StringConstraint constraint) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (this.nextString(constraint, buf) == 0) {
            return Optional.empty();
        }
        return Optional.of(buf.toString());
    }

    public IntStream nextChars(final IntPredicate predicate) {
        return StreamSupport.intStream(new Spliterators.AbstractIntSpliterator(Long.MAX_VALUE, 1296){

            @Override
            public boolean tryAdvance(IntConsumer action) {
                if (Scanner.this.hasNext() && predicate.test(Scanner.this.lookAhead())) {
                    action.accept(Scanner.this.lookAhead());
                    Thrower.safeCall(() -> Scanner.this.read());
                    return true;
                }
                return false;
            }
        }, false);
    }

    public int skipNextString(StringConstraint constraint) throws IOException {
        this.state.sourceIndex = 0;
        while (!this.state.end && !constraint.stopCondition(this.state.sourceIndex, 0, this)) {
            ++this.state.sourceIndex;
            this.state.source.read();
        }
        return this.state.sourceIndex;
    }

    public int lookAhead() {
        return this.state.next;
    }

    public int nextChar() throws IOException {
        if (this.state.end) {
            return -1;
        }
        int c = this.state.next;
        this.state.source.read();
        return c;
    }

    public Number nextNumber() throws IOException {
        return this.nextNumber(NumberConstraint.NO_CONSTRAINT);
    }

    public Number nextNumber(NumberConstraint constraint) throws IOException {
        StringBuffer buf = new StringBuffer();
        this.state.source.mark();
        boolean isFloatingPoint = this.parseNumber(buf, constraint);
        if (buf.length() > 0) {
            try {
                String number = buf.toString();
                Number n = NumberUtil.parseNumber((String)number, (boolean)isFloatingPoint, constraint.getNumberType());
                this.state.source.consume();
                return n;
            }
            catch (NumberFormatException nfe) {
                this.state.source.cancel();
                return null;
            }
        }
        this.state.source.cancel();
        return null;
    }

    private boolean parseNumber(StringBuffer buf, NumberConstraint constraint) throws IOException {
        this.state.sourceIndex = 0;
        int length = 0;
        int dotIndex = -1;
        int exponentIndex = -1;
        if (constraint.stopCondition(buf, this.state.sourceIndex, dotIndex, exponentIndex, this)) {
            return false;
        }
        int prev = 65535;
        boolean isFloatingPoint = false;
        char sign = (char)this.nextChar("-+", true);
        switch (sign) {
            case '-': {
                buf.append(sign);
                ++length;
                ++this.state.sourceIndex;
            }
            case '+': {
                prev = sign;
            }
        }
        if (constraint.stopCondition(buf, this.state.sourceIndex, dotIndex, exponentIndex, this)) {
            return isFloatingPoint;
        }
        int c = this.lookAhead();
        while (c >= 48 && c <= 57) {
            if (prev == 48 && (length == 1 || length == 2 && sign == '-')) {
                buf.setCharAt(length - 1, (char)c);
            } else {
                ++length;
                buf.append((char)c);
            }
            this.state.source.read();
            ++this.state.sourceIndex;
            if (constraint.stopCondition(buf, this.state.sourceIndex, dotIndex, exponentIndex, this)) {
                return isFloatingPoint;
            }
            prev = (char)c;
            c = this.lookAhead();
        }
        if (constraint.stopCondition(buf, this.state.sourceIndex, dotIndex, exponentIndex, this)) {
            return isFloatingPoint;
        }
        if (this.hasNextChar(46, true)) {
            isFloatingPoint = true;
            buf.append('.');
            ++this.state.sourceIndex;
            dotIndex = this.state.sourceIndex;
            if (constraint.stopCondition(buf, this.state.sourceIndex, dotIndex, exponentIndex, this)) {
                return isFloatingPoint;
            }
            c = this.lookAhead();
            while (c >= 48 && c <= 57) {
                ++length;
                buf.append((char)c);
                this.state.source.read();
                ++this.state.sourceIndex;
                if (constraint.stopCondition(buf, this.state.sourceIndex, dotIndex, exponentIndex, this)) {
                    return isFloatingPoint;
                }
                c = this.lookAhead();
            }
        }
        if (constraint.stopCondition(buf, this.state.sourceIndex, dotIndex, exponentIndex, this)) {
            return isFloatingPoint;
        }
        if (this.hasNextChar("eE", true)) {
            isFloatingPoint = true;
            buf.append('e');
            ++this.state.sourceIndex;
            exponentIndex = this.state.sourceIndex;
            sign = (char)this.nextChar("-+", true);
            if (constraint.stopCondition(buf, this.state.sourceIndex, dotIndex, exponentIndex, this)) {
                return isFloatingPoint;
            }
            if (sign != '\uffffffff') {
                buf.append(sign);
                ++this.state.sourceIndex;
            }
            if (constraint.stopCondition(buf, this.state.sourceIndex, dotIndex, exponentIndex, this)) {
                return isFloatingPoint;
            }
            c = this.lookAhead();
            while (c >= 48 && c <= 57) {
                buf.append((char)c);
                this.state.source.read();
                ++this.state.sourceIndex;
                if (constraint.stopCondition(buf, this.state.sourceIndex, dotIndex, exponentIndex, this)) {
                    return isFloatingPoint;
                }
                c = this.lookAhead();
            }
        }
        return isFloatingPoint;
    }

    public <T> Optional<T> nextEnumValue(Class<? extends Enum> values) throws IOException {
        return EnumValues.from(values).nextValue(this);
    }

    public <T> Optional<T> nextEnumValue(EnumValues<T> values) throws IOException {
        return values.nextValue(this);
    }

    public Optional<Integer> nextChar(CharRange range) throws IOException {
        int c = this.lookAhead();
        if (range.contains(c)) {
            this.read();
            return Optional.of(c);
        }
        return Optional.empty();
    }

    public Optional<String> nextEnumString(String ... values) throws IOException {
        return EnumValues.from(values).nextValue(this);
    }

    public Optional<String> nextEnumString(Stream<String> values) throws IOException {
        return EnumValues.from(values).nextValue(this);
    }

    public Optional<String> nextEnumString(EnumValues<String> values) throws IOException {
        return values.nextValue(this);
    }

    public boolean hasNext() {
        return !this.state.end;
    }

    public int getSourceIndex() {
        return this.state.sourceIndex;
    }

    public boolean hasNextChar(int c, boolean consume) throws IOException {
        if (this.state.next == c && !this.state.end) {
            if (consume) {
                this.state.source.read();
            }
            return true;
        }
        return false;
    }

    public boolean hasNextChar(String chars, boolean consume) throws IOException {
        if (!this.state.end && chars.indexOf(this.state.next) >= 0) {
            if (consume) {
                this.state.source.read();
            }
            return true;
        }
        return false;
    }

    public int nextChar(String chars, boolean consume) throws IOException {
        if (!this.state.end && chars.indexOf(this.state.next) >= 0) {
            int c = this.state.next;
            if (consume) {
                this.state.source.read();
            }
            return c;
        }
        return -1;
    }

    public boolean hasNextString(CharSequence string, boolean consume) throws IOException {
        if (string == null) {
            return true;
        }
        if (this.state.end) {
            return false;
        }
        int len = string.length();
        if (len == 0) {
            return true;
        }
        int c = this.state.next;
        if (c == Scanner.codePointAt(string, 0)) {
            int start = Character.charCount(c);
            if (len > start) {
                this.state.source.mark();
                for (int i = start; i < len; ++i) {
                    this.state.source.read();
                    if (this.state.end) {
                        this.state.source.cancel();
                        return false;
                    }
                    c = Scanner.codePointAt(string, i);
                    if (c != this.state.next) {
                        this.state.source.cancel();
                        return false;
                    }
                    if (!Character.isSupplementaryCodePoint(c)) continue;
                    ++i;
                }
                if (consume) {
                    this.state.source.consume();
                    this.state.source.read();
                } else {
                    this.state.source.cancel();
                }
            } else if (consume) {
                this.state.source.read();
            }
            return true;
        }
        return false;
    }

    public abstract void read() throws IOException;

    public abstract void mark();

    public abstract void cancel() throws IllegalStateException;

    public abstract void consume() throws IllegalStateException;

    protected void push(int cursor) {
        this.state.cursors.push(new Cursor(cursor));
    }

    protected int pop() {
        if (this.state.cursors.isEmpty()) {
            throw new RuntimeException("Unbalanced stack.");
        }
        return this.state.cursors.pop().mark;
    }

    protected int peek() {
        return this.state.cursors.peek().mark;
    }

    public abstract Optional<Reader> getRemainder() throws IOException;

    public abstract Optional<String> getRemainderString() throws IOException;

    static int codePointAt(CharSequence string, int index) {
        char c2;
        char c1;
        if (Character.isHighSurrogate(c1 = string.charAt(index++)) && Character.isLowSurrogate(c2 = string.charAt(index))) {
            return Character.toCodePoint(c1, c2);
        }
        return c1;
    }

    static class State {
        Scanner source;
        Stack<Cursor> cursors = new Stack();
        protected int cursor;
        protected int next;
        protected boolean end = false;
        int sourceIndex = 0;

        State(Scanner scanner) {
            this.source = scanner;
        }

        public String toString() {
            return (this.end ? "{END} " : '\'' + new String(Character.toChars(this.next)) + "' ") + this.cursor + '/' + this.cursors;
        }
    }

    static class Cursor {
        int mark;

        Cursor(int cursor) {
            this.mark = cursor;
        }

        public String toString() {
            return "" + this.mark;
        }
    }
}

